/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.w2x.processor.Msg;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Start {
    protected ArrayList<URL> jarList = new ArrayList();
    protected ArrayList<URL> pluginList = new ArrayList();
    protected ArrayList<String> errorList = new ArrayList();
    public static final String PLUGIN_SUFFIX = ".w2x_plugin";

    public static void main(String[] stringArray) {
        new Start().start("com.xmlmind.w2x.processor.Main", stringArray);
    }

    protected Start() {
    }

    protected void start(String string, String[] stringArray) {
        File file = Start.findInstallDir();
        if (file == null) {
            System.err.println(Msg.msg("installDirNotFound"));
            System.exit(2);
        }
        Start.scanPluginDirs(file, this.jarList, this.pluginList, this.errorList);
        ClassLoader classLoader = this.createClassLoader();
        this.doStart(classLoader, string, file, stringArray);
    }

    protected void doStart(ClassLoader classLoader, String string, File file, String[] stringArray) {
        try {
            Object object = this.createApp(classLoader, string, file);
            this.runApp(object, stringArray);
        }
        catch (Exception exception) {
            Throwable throwable = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException() : exception;
            System.err.println(Msg.msg("cannotCreateApp", ThrowableUtil.detailedReason(throwable)));
            System.exit(3);
        }
    }

    protected ClassLoader createClassLoader() {
        ClassLoader classLoader;
        if (this.jarList.size() > 0) {
            URL[] uRLArray = this.getClassPath();
            ClassLoader classLoader2 = null;
            ClassLoader classLoader3 = ClassLoader.getSystemClassLoader();
            if (classLoader3 != null) {
                classLoader2 = classLoader3.getParent();
            }
            classLoader = new URLClassLoader(uRLArray, classLoader2);
        } else {
            classLoader = Start.class.getClassLoader();
        }
        return classLoader;
    }

    protected URL[] getClassPath() {
        Start.prependClasspath(this.jarList);
        return this.getJars();
    }

    protected static final void prependClasspath(List<URL> list) {
        String string = System.getProperty("java.class.path");
        if (string != null) {
            String[] stringArray = StringUtil.split(string, File.pathSeparatorChar);
            for (int i = stringArray.length - 1; i >= 0; --i) {
                URL uRL;
                String string2 = stringArray[i].trim();
                if (string2.length() == 0 || (uRL = URLUtil.urlOrFile(string2, false, true)) == null) continue;
                list.add(0, uRL);
            }
        }
    }

    protected URL[] getJars() {
        URL[] uRLArray = new URL[this.jarList.size()];
        this.jarList.toArray(uRLArray);
        return uRLArray;
    }

    protected Object createApp(ClassLoader classLoader, String string, File file) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("installDirectory", file);
        hashMap.put("searchPluginErrors", this.getErrors());
        hashMap.put("pluginURLs", this.getPlugins());
        Class<?> clazz = classLoader.loadClass(string);
        Constructor<?> constructor = clazz.getConstructor(Map.class);
        return constructor.newInstance(hashMap);
    }

    protected URL[] getPlugins() {
        URL[] uRLArray = new URL[this.pluginList.size()];
        this.pluginList.toArray(uRLArray);
        return uRLArray;
    }

    protected String[] getErrors() {
        String[] stringArray = new String[this.errorList.size()];
        this.errorList.toArray(stringArray);
        return stringArray;
    }

    protected void runApp(Object object, String[] stringArray) throws Exception {
        Method method = object.getClass().getMethod("run", String[].class);
        method.invoke(object, new Object[]{stringArray});
    }

    public static File findInstallDir() {
        File file = null;
        String string = System.getProperty("java.class.path");
        if (string != null) {
            String[] stringArray = StringUtil.split(string, File.pathSeparatorChar);
            for (int i = 0; i < stringArray.length; ++i) {
                File file2;
                String string2 = stringArray[i].trim();
                if (string2.length() == 0) continue;
                if (string2.endsWith("w2x.jar") || string2.endsWith("w2x_all.jar") || string2.endsWith("w2x_app.jar")) {
                    file2 = new File(string2);
                    if (!file2.isFile()) continue;
                    try {
                        file2 = file2.getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        break;
                    }
                    file = file2.getParentFile();
                    if (file == null || (file = file.getParentFile()) != null) break;
                    break;
                }
                if (!string2.endsWith("class") || !(file2 = new File(string2)).isDirectory()) continue;
                try {
                    file2 = file2.getCanonicalFile();
                }
                catch (IOException iOException) {
                    break;
                }
                file = file2.getParentFile();
                if (file != null) break;
                break;
            }
        }
        return file;
    }

    public static final void scanPluginDirs(File file, List<URL> list, List<URL> list2, List<String> list3) {
        String string = System.getProperty("W2X_PLUGIN_PATH");
        if (string == null) {
            string = System.getenv("W2X_PLUGIN_PATH");
        }
        if (string == null) {
            string = "+";
        }
        String string2 = null;
        if (file != null) {
            string2 = new File(file, "plugin").getAbsolutePath();
        }
        if (string != null && (string = string.trim()).length() > 0) {
            String[] stringArray;
            for (String string3 : stringArray = StringUtil.split(string, ';')) {
                File file2;
                if ("+".equals(string3 = string3.trim())) {
                    string3 = string2 != null ? string2 : "";
                }
                if (string3.length() <= 0 || !(file2 = new File(string3).getAbsoluteFile()).isDirectory()) continue;
                Start.scanPluginDir(file2, list, list2, list3);
            }
        }
    }

    public static final void scanPluginDir(File file, List<URL> list, List<URL> list2, List<String> list3) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            list3.add(Msg.msg("cannotListDir", file));
            return;
        }
        for (File file2 : fileArray) {
            URL uRL;
            if (file2.isDirectory()) {
                Start.scanPluginDir(file2, list, list2, list3);
                continue;
            }
            String string = file2.getName();
            if (string.endsWith(".jar")) {
                uRL = FileUtil.fileToURL(file2);
                list.add(uRL);
                continue;
            }
            if (!string.endsWith(PLUGIN_SUFFIX)) continue;
            uRL = FileUtil.fileToURL(file2);
            list2.add(uRL);
        }
    }
}

