/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.w2x.processor.Msg;
import com.xmlmind.w2x.processor.Processor;
import com.xmlmind.w2x.processor.UsageException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Plugin {
    public final String name;
    public final String outputDescription;
    public final String outputExtension;
    public final boolean multiFileOutput;
    public final String[] w2xArguments;
    public static final Plugin[] EMPTY_LIST = new Plugin[0];
    private static final Pattern FIELD_PATTERN = Pattern.compile("^[#]+([^:]+):(.*)$", 2);

    public Plugin(String string, String string2, String string3, boolean bl, String[] stringArray) {
        this.name = string;
        this.outputDescription = string2;
        this.outputExtension = string3;
        this.multiFileOutput = bl;
        this.w2xArguments = stringArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# plugin.name: ");
        stringBuilder.append(this.name);
        stringBuilder.append('\n');
        stringBuilder.append("# plugin.outputDescription: ");
        if (this.outputDescription != null) {
            stringBuilder.append(this.outputDescription);
        }
        stringBuilder.append('\n');
        stringBuilder.append("# plugin.outputExtension: ");
        stringBuilder.append(this.outputExtension);
        stringBuilder.append('\n');
        stringBuilder.append("# plugin.multiFileOutput: ");
        stringBuilder.append(Boolean.toString(this.multiFileOutput));
        stringBuilder.append('\n');
        for (String string : this.w2xArguments) {
            stringBuilder.append(string.startsWith("-") ? (char)'\n' : ' ');
            stringBuilder.append(StringUtil.quoteArgument(string));
        }
        return stringBuilder.toString();
    }

    public static Plugin[] loadAll(URL[] uRLArray, List<String> list) {
        HashMap<String, Plugin> hashMap = new HashMap<String, Plugin>();
        for (URL uRL : uRLArray) {
            try {
                Plugin plugin = Plugin.load(uRL);
                hashMap.put(plugin.name, plugin);
            }
            catch (Exception exception) {
                list.add(Msg.msg("cannotLoadPlugin", URLUtil.toLabel(uRL), ThrowableUtil.reason(exception)));
            }
        }
        return hashMap.values().toArray(EMPTY_LIST);
    }

    public static Plugin load(URL uRL) throws IOException, UsageException {
        String string = URLUtil.loadString(uRL, "UTF-8");
        String string2 = null;
        String string3 = null;
        String string4 = "xml";
        boolean bl = false;
        Matcher matcher = FIELD_PATTERN.matcher("");
        String[] stringArray = StringUtil.split(string, '\n');
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string5 = stringArray[i];
            if (!(string5 = string5.trim()).startsWith("#")) continue;
            matcher.reset(string5);
            if (!matcher.matches()) continue;
            String string6 = matcher.group(1).trim().toLowerCase();
            String string7 = matcher.group(2).trim();
            if ("plugin.name".equals(string6)) {
                string2 = string7;
                continue;
            }
            if ("plugin.outputdescription".equals(string6)) {
                string3 = string7;
                if (string3.length() != 0) continue;
                string3 = null;
                continue;
            }
            if ("plugin.outputextension".equals(string6)) {
                string4 = string7;
                if (!string4.startsWith(".")) continue;
                string4 = string4.substring(1);
                continue;
            }
            if (!"plugin.multifileoutput".equals(string6)) continue;
            bl = "true".equals(string7) || "yes".equals(string7) || "on".equals(string7) || "1".equals(string7);
        }
        if (string2 == null) {
            int n2;
            string2 = URLUtil.getBaseName(uRL);
            string2 = string2.endsWith(".w2x_plugin") && (n2 = string2.length()) > (n = ".w2x_plugin".length()) ? string2.substring(0, n2 - n) : null;
        }
        if (string2 == null || string2.length() == 0) {
            throw new IOException(Msg.msg("missingPluginField", "plugin.name"));
        }
        if (string4 == null || string4.length() == 0) {
            throw new IOException(Msg.msg("missingPluginField", "plugin.outputExtension"));
        }
        stringArray = Processor.parseOptions(string, uRL);
        if (stringArray.length == 0) {
            throw new IOException(Msg.msg("uselessPlugin"));
        }
        return new Plugin(string2, string3, string4, bl, stringArray);
    }
}

