/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.Console;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.ProgressMonitor;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.URIComponent;
import com.xmlmind.util.URLUtil;
import com.xmlmind.util.Zip;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.processor.CanceledException;
import com.xmlmind.w2x.processor.Msg;
import com.xmlmind.w2x.processor.SplitStep;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.DocumentTypeDeclaration;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.save.SaveDocument;
import com.xmlmind.xml.save.SaveOptions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.zip.ZipOutputStream;

public class EpubStep
extends SplitStep {
    protected static final Namespace OPS_NS = Namespace.get("http://www.idpf.org/2007/ops");
    protected static final Name SWITCH_NAME = Name.get(OPS_NS, "switch");
    protected static final Name CASE_NAME = Name.get(OPS_NS, "case");
    protected static final Name DEFAULT_NAME = Name.get(OPS_NS, "default");
    protected static final Name REQUIRED_NAMESPACE_NAME = Name.get("required-namespace");
    protected static final Namespace NCX_NS = Namespace.get("http://www.daisy.org/z3986/2005/ncx/");
    protected static final PrefixEntry[] NCX_PREFIX_ENTRIES = new PrefixEntry[]{new PrefixEntry("", NCX_NS)};
    protected static final Name NCX_NAME = Name.get(NCX_NS, "ncx");
    protected static final Name HEAD_NAME = Name.get(NCX_NS, "head");
    protected static final Name META_NAME = Name.get(NCX_NS, "meta");
    protected static final Name DOC_TITLE_NAME = Name.get(NCX_NS, "docTitle");
    protected static final Name TEXT_NAME = Name.get(NCX_NS, "text");
    protected static final Name NAV_MAP_NAME = Name.get(NCX_NS, "navMap");
    protected static final Name NAV_POINT_NAME = Name.get(NCX_NS, "navPoint");
    protected static final Name NAV_LABEL_NAME = Name.get(NCX_NS, "navLabel");
    protected static final Name CONTENT_NAME = Name.get(NCX_NS, "content");
    protected static final Name VERSION_NAME = Name.get("version");
    protected static final Name PLAY_ORDER_NAME = Name.get("playOrder");
    protected static final Namespace OPF_NS = Namespace.get("http://www.idpf.org/2007/opf");
    protected static final Namespace DC_NS = Namespace.get("http://purl.org/dc/elements/1.1/");
    protected static final Namespace DCTERMS_NS = Namespace.get("http://purl.org/dc/terms/");
    protected static final PrefixEntry[] OPF_PREFIX_ENTRIES = new PrefixEntry[]{new PrefixEntry("", OPF_NS), new PrefixEntry("dc", DC_NS), new PrefixEntry("dcterms", DCTERMS_NS)};
    protected static final Name PACKAGE_NAME = Name.get(OPF_NS, "package");
    protected static final Name METADATA_NAME = Name.get(OPF_NS, "metadata");
    protected static final Name OPF_META_NAME = Name.get(OPF_NS, "meta");
    protected static final Name MANIFEST_NAME = Name.get(OPF_NS, "manifest");
    protected static final Name ITEM_NAME = Name.get(OPF_NS, "item");
    protected static final Name SPINE_NAME = Name.get(OPF_NS, "spine");
    protected static final Name ITEMREF_NAME = Name.get(OPF_NS, "itemref");
    protected static final Name GUIDE_NAME = Name.get(OPF_NS, "guide");
    protected static final Name REFERENCE_NAME = Name.get(OPF_NS, "reference");
    protected static final Name UNIQUE_IDENTIFIER_NAME = Name.get("unique-identifier");
    protected static final Name MEDIA_TYPE_NAME = Name.get("media-type");
    protected static final Name TOC_NAME = Name.get("toc");
    protected static final Name IDREF_NAME = Name.get("idref");
    protected static final Name LINEAR_NAME = Name.get("linear");
    protected static final String COVER_HTML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\n               \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n<html lang=\"en-US\" xmlns=\"http://www.w3.org/1999/xhtml\">\n  <head>\n    <title>Cover</title>\n    <style type=\"text/css\">img { max-width: 100%; }</style>\n  </head>\n  <body>\n    <div id=\"cover-image\">\n      <img src=\"%I\" alt=\"Cover image\"/>\n    </div>\n  </body>\n</html>\n";
    private static final String CONTAINER_XML = "<?xml version=\"1.0\"?>\n<container version=\"1.0\"\n           xmlns=\"urn:oasis:names:tc:opendocument:xmlns:container\">\n  <rootfiles>\n    <rootfile full-path=\"content.opf\"\n              media-type=\"application/oebps-package+xml\"/>\n  </rootfiles>\n</container>\n";

    public EpubStep(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Object[] objectArray, Map<String, String> map, int[] nArray, ProgressMonitor progressMonitor) throws Exception {
        File file;
        if (!(objectArray[0] instanceof Document)) {
            this.illegalState(Document.class);
        }
        Document document = (Document)objectArray[0];
        File file2 = null;
        URL uRL = document.getSourceURL();
        if (uRL != null) {
            file2 = URLUtil.urlToFile(uRL);
        }
        if (file2 == null || !"xhtml".equalsIgnoreCase(FileUtil.getExtension(file2))) {
            throw new RuntimeException("internal error: missing or unusable convert.xhtml-file");
        }
        try {
            file = this.doProcess(document, file2, map, nArray, progressMonitor);
        }
        finally {
            File file3 = file2.getParentFile();
            if (file3 != null && file3.isDirectory()) {
                try {
                    FileUtil.deleteDir(file3);
                }
                catch (IOException iOException) {}
            }
        }
        objectArray[0] = file;
    }

    protected File doProcess(Document document, File file, Map<String, String> map, int[] nArray, ProgressMonitor progressMonitor) throws Exception {
        File file2 = this.getFileParameter(map, "out-file", null);
        if (file2 == null) {
            this.missingParameter("out-file");
        }
        this.progress(Msg.msg("epubStep", file2), nArray, progressMonitor);
        this.debugParameters(map, progressMonitor);
        Object object = this.getParameter(map, "identifier", null);
        if (object == null || ((String)(object = ((String)object).trim())).length() == 0) {
            object = "urn:uuid:" + String.valueOf(UUID.randomUUID());
        }
        String string = this.getParameter(map, "default-lang", "en");
        URL uRL = this.getURLParameter(map, "cover-image-url-or-file", null);
        boolean bl = this.getBooleanParameter(map, "omit-toc-root", false);
        int n = this.getIntParameter(map, "split-before-level", 0, 8, 0);
        boolean bl2 = this.getBooleanParameter(map, "allow-lonely-heading", false);
        boolean bl3 = this.getBooleanParameter(map, "indent", false);
        ArrayList<SplitStep.Part> arrayList = new ArrayList<SplitStep.Part>();
        this.splitDocument(document, n, null, bl2, file, arrayList, progressMonitor);
        this.processParts(arrayList, document);
        this.saveParts(arrayList, bl3, "UTF-8", file, progressMonitor);
        File file3 = file.getParentFile();
        this.saveTOC(arrayList, (String)object, bl, new File(file3, "toc.ncx"), progressMonitor);
        String string2 = null;
        String string3 = null;
        if (uRL != null && (string3 = this.saveCover(uRL, new File(file3, string2 = "__cover.xhtml"), progressMonitor)) == null) {
            string2 = null;
        }
        this.saveContent(arrayList, string2, string3, (String)object, string, document, new File(file3, "content.opf"), progressMonitor);
        this.createEpub(file3, file2, progressMonitor);
        return file2;
    }

    @Override
    protected void saveDocument(Document document, boolean bl, String string, File file, ProgressMonitor progressMonitor) throws CanceledException, IOException {
        this.wrapMathML(document.getRootElement());
        super.saveDocument(document, bl, string, file, progressMonitor);
    }

    private void wrapMathML(Element element) {
        if (element.getName() == Name.MATH) {
            Element element2 = new Element(SWITCH_NAME);
            element.getParent().replaceChild(element, element2);
            Element element3 = new Element(CASE_NAME);
            element2.appendChild(element3);
            element3.putAttribute(REQUIRED_NAMESPACE_NAME, element.getNamespace().uri);
            element3.appendChild(element);
            Element element4 = new Element(DEFAULT_NAME);
            element2.appendChild(element4);
            Element element5 = new Element(Constants.SPAN_ELEM);
            element4.appendChild(element5);
            return;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getType() == Node.Type.ELEMENT) {
                this.wrapMathML((Element)node);
            }
            node = node2;
        }
    }

    protected void saveTOC(List<SplitStep.Part> list, String string, boolean bl, File file, ProgressMonitor progressMonitor) throws CanceledException, IOException {
        EpubStep.creatingFile(file, progressMonitor);
        SaveOptions saveOptions = new SaveOptions();
        saveOptions.encoding = "UTF-8";
        saveOptions.preferredPrefixes = NCX_PREFIX_ENTRIES;
        saveOptions.useOriginalPrefixes = false;
        saveOptions.indent = 2;
        saveOptions.addOpenLines = false;
        saveOptions.maxLineLength = Integer.MAX_VALUE;
        SaveDocument.save(this.toTOC(list, string, bl), file, saveOptions);
    }

    protected Document toTOC(List<SplitStep.Part> list, String string, boolean bl) {
        Element element;
        Document document = new Document();
        DocumentTypeDeclaration documentTypeDeclaration = new DocumentTypeDeclaration("ncx", "-//NISO//DTD ncx 2005-1//EN", "http://www.daisy.org/z3986/2005/ncx-2005-1.dtd", null);
        document.appendChild(documentTypeDeclaration);
        Element element2 = new Element(NCX_NAME);
        document.appendChild(element2);
        element2.putAttribute(VERSION_NAME, "2005-1");
        Element element3 = new Element(HEAD_NAME);
        element2.appendChild(element3);
        Element element4 = EpubStep.newMeta("dtb:uid", string);
        element3.appendChild(element4);
        Element element5 = EpubStep.newMeta("dtb:depth", "0");
        element3.appendChild(element5);
        element4 = EpubStep.newMeta("dtb:totalPageCount", "0");
        element3.appendChild(element4);
        element4 = EpubStep.newMeta("dtb:maxPageNumber", "0");
        element3.appendChild(element4);
        Element element6 = new Element(DOC_TITLE_NAME);
        element2.appendChild(element6);
        int n = list.size();
        if (n > 0) {
            element = EpubStep.newText(list.get((int)0).title);
            element6.appendChild(element);
        }
        element = new Element(NAV_MAP_NAME);
        element2.appendChild(element);
        if (n > 0) {
            Stack<SplitStep.Part> stack = new Stack<SplitStep.Part>();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3;
                SplitStep.Part part = list.get(i);
                Element element7 = null;
                if (i > 0 || !bl) {
                    element7 = new Element(NAV_POINT_NAME);
                    n3 = bl ? i : 1 + i;
                    String string2 = Integer.toString(n3);
                    element7.putAttribute(Constants.ID_ATTR, "navPoint-" + string2);
                    element7.putAttribute(PLAY_ORDER_NAME, string2);
                    Element element8 = new Element(NAV_LABEL_NAME);
                    element7.appendChild(element8);
                    element8.appendChild(EpubStep.newText(part.title));
                    Element element9 = new Element(CONTENT_NAME);
                    element7.appendChild(element9);
                    element9.putAttribute(Constants.SRC_ATTR, part.href);
                    part.clientData = element7;
                }
                if (i == 0) {
                    if (bl) {
                        part.clientData = element;
                    } else {
                        element.appendChild(element7);
                    }
                } else {
                    SplitStep.Part part2 = (SplitStep.Part)stack.peek();
                    while (part2.level >= part.level) {
                        stack.pop();
                        part2 = (SplitStep.Part)stack.peek();
                    }
                    ((Element)part2.clientData).appendChild(element7);
                }
                stack.push(part);
                n3 = stack.size();
                if (n3 <= n2) continue;
                n2 = n3;
            }
            if (bl) {
                --n2;
            }
            element5.putAttribute(Constants.CONTENT_ATTR, Integer.toString(n2));
        }
        return document;
    }

    protected static final Element newMeta(String string, String string2) {
        Element element = new Element(META_NAME);
        element.putAttribute(Constants.NAME_ATTR, string);
        element.putAttribute(Constants.CONTENT_ATTR, string2);
        return element;
    }

    protected static final Element newText(String string) {
        Element element = new Element(TEXT_NAME);
        element.appendChild(new Text(string));
        return element;
    }

    protected String saveCover(URL uRL, File file, ProgressMonitor progressMonitor) throws CanceledException, IOException {
        EpubStep.creatingFile(file, progressMonitor);
        String string = URLUtil.getExtension(uRL);
        if (string == null || string.length() == 0) {
            if (!progressMonitor.message(Msg.msg("noFileExtension", URLUtil.toLabel(uRL)), Console.MessageType.WARNING)) {
                throw new CanceledException();
            }
            return null;
        }
        Object object = FileUtil.setExtension(file.getName(), null) + "_image." + string;
        File file2 = new File(file.getParentFile(), (String)object);
        FileUtil.copyFile(uRL, file2);
        object = URIComponent.quotePath((String)object);
        String string2 = StringUtil.replaceAll(COVER_HTML, "%I", (String)object);
        FileUtil.saveString(string2, file, "UTF-8");
        return object;
    }

    protected void saveContent(List<SplitStep.Part> list, String string, String string2, String string3, String string4, Document document, File file, ProgressMonitor progressMonitor) throws CanceledException, IOException {
        EpubStep.creatingFile(file, progressMonitor);
        SaveOptions saveOptions = new SaveOptions();
        saveOptions.encoding = "UTF-8";
        saveOptions.preferredPrefixes = OPF_PREFIX_ENTRIES;
        saveOptions.useOriginalPrefixes = false;
        saveOptions.indent = 2;
        saveOptions.addOpenLines = false;
        saveOptions.maxLineLength = Integer.MAX_VALUE;
        SaveDocument.save(this.toContent(list, string, string2, string3, string4, document, file.getParentFile()), file, saveOptions);
    }

    protected Document toContent(List<SplitStep.Part> list, String string, String string2, String string3, String string4, Document document, File file) throws IOException {
        Object object;
        int n;
        Object object2;
        Object object3;
        Object object4;
        Document document2 = new Document();
        Element element = new Element(PACKAGE_NAME);
        document2.appendChild(element);
        element.putAttribute(VERSION_NAME, "2.0");
        element.putAttribute(UNIQUE_IDENTIFIER_NAME, "__ID");
        Element element2 = new Element(METADATA_NAME);
        element.appendChild(element2);
        int n2 = list.size();
        if (n2 > 0) {
            object4 = list.get(0);
            element2.appendChild(EpubStep.newSimpleElement(DC_NS, "title", ((SplitStep.Part)object4).title));
            object3 = ((SplitStep.Part)object4).lang;
            if (object3 == null) {
                object3 = string4;
            }
            element2.appendChild(EpubStep.newSimpleElement(DC_NS, "language", (String)object3));
            Element element3 = EpubStep.newSimpleElement(DC_NS, "identifier", string3);
            element3.putAttribute(Constants.ID_ATTR, "__ID");
            element2.appendChild(element3);
            this.addMeta(document, element2);
            if (string != null) {
                object2 = new Element(OPF_META_NAME);
                element2.appendChild((Node)object2);
                ((Element)object2).putAttribute(Constants.NAME_ATTR, "cover");
                ((Element)object2).putAttribute(Constants.CONTENT_ATTR, "cover-image");
            }
        }
        object4 = new Element(MANIFEST_NAME);
        element.appendChild((Node)object4);
        object3 = new HashMap();
        for (n = 0; n < n2; ++n) {
            object2 = list.get(n);
            if (((SplitStep.Part)object2).file == null) continue;
            ((HashMap)object3).put(((SplitStep.Part)object2).file, "__PART" + n);
        }
        ((HashMap)object3).put(new File(file, "toc.ncx"), "__TOC");
        if (string != null) {
            ((HashMap)object3).put(new File(file, string), "cover");
            ((HashMap)object3).put(new File(file, string2), "cover-image");
        }
        n = FileUtil.fileToURL(file).toExternalForm().length();
        this.addItems(file, n, (Map<File, String>)object3, (Element)object4);
        object2 = new Element(SPINE_NAME);
        element.appendChild((Node)object2);
        ((Element)object2).putAttribute(TOC_NAME, "__TOC");
        if (string != null) {
            object = EpubStep.newItemref("cover");
            ((Tree)object2).appendChild((Node)object);
            ((Element)object).putAttribute(LINEAR_NAME, "no");
        }
        for (SplitStep.Part object5 : list) {
            if (object5.file == null) continue;
            ((Tree)object2).appendChild(EpubStep.newItemref((String)((HashMap)object3).get(object5.file)));
        }
        if (string != null) {
            object = new Element(GUIDE_NAME);
            element.appendChild((Node)object);
            Element element3 = new Element(REFERENCE_NAME);
            ((Tree)object).appendChild(element3);
            element3.putAttribute(Constants.TYPE_ATTR, "cover");
            element3.putAttribute(Constants.TITLE_ATTR, "Cover");
            element3.putAttribute(Constants.HREF_ATTR, string);
        }
        return document2;
    }

    protected static final Element newSimpleElement(Namespace namespace, String string, String string2) {
        Element element = new Element(Name.get(namespace, string));
        element.appendChild(new Text(string2));
        return element;
    }

    protected void addMeta(Document document, Element element) {
        Element element2 = document.getRootElement().getChildElement(0);
        for (Node node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element3;
            if (node.getType() != Node.Type.ELEMENT || (element3 = (Element)node).getName() != Constants.META_ELEM) continue;
            Element element4 = null;
            String string = element3.getAttribute(Constants.NAME_ATTR);
            String string2 = element3.getAttribute(Constants.CONTENT_ATTR);
            if (string != null && string2 != null) {
                if ("author".equals(string)) {
                    element4 = EpubStep.newSimpleElement(DC_NS, "creator", string2);
                } else if ("description".equals(string)) {
                    element4 = EpubStep.newSimpleElement(DC_NS, "description", string2);
                } else if ("ms-ep-Company".equals(string)) {
                    element4 = EpubStep.newSimpleElement(DC_NS, "publisher", string2);
                } else if (string.startsWith("dc.")) {
                    element4 = EpubStep.newSimpleElement(DC_NS, string.substring(3), string2);
                } else if (string.startsWith("dcterms.")) {
                    element4 = EpubStep.newSimpleElement(DCTERMS_NS, string.substring(8), string2);
                }
            }
            if (element4 == null) continue;
            element.appendChild(element4);
        }
    }

    protected static final Element newItem(String string, String string2, String string3) {
        Element element = new Element(ITEM_NAME);
        element.putAttribute(Constants.ID_ATTR, string);
        element.putAttribute(Constants.HREF_ATTR, string2);
        element.putAttribute(MEDIA_TYPE_NAME, string3);
        return element;
    }

    protected void addItems(File file, int n, Map<File, String> map, Element element) throws IOException {
        File[] fileArray = FileUtil.checkedListFiles(file);
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    this.addItems(file2, n, map, element);
                    continue;
                }
                Object object = map.get(file2);
                if (object == null) {
                    object = "__ITEM" + map.size();
                    map.put(file2, (String)object);
                }
                String string = FileUtil.fileToURL(file2).toExternalForm();
                string = string.substring(n);
                element.appendChild(EpubStep.newItem((String)object, string, this.mediaType(FileUtil.getExtension(file2))));
            }
        }
    }

    protected String mediaType(String string) {
        if ((string = string == null ? "" : string.toLowerCase()).startsWith("xht") || string.indexOf("htm") >= 0) {
            return "application/xhtml+xml";
        }
        if ("png".equals(string)) {
            return "image/png";
        }
        if ("jpeg".equals(string) || "jpg".equals(string)) {
            return "image/jpeg";
        }
        if ("gif".equals(string)) {
            return "image/gif";
        }
        if ("svg".equals(string)) {
            return "image/svg+xml";
        }
        if ("wmf".equals(string)) {
            return "image/x-wmf";
        }
        if ("emf".equals(string)) {
            return "image/x-emf";
        }
        if ("css".equals(string)) {
            return "text/css";
        }
        if ("js".equals(string)) {
            return "text/javascript";
        }
        if ("ncx".equals(string)) {
            return "application/x-dtbncx+xml";
        }
        return "application/octet-stream";
    }

    protected static final Element newItemref(String string) {
        Element element = new Element(ITEMREF_NAME);
        element.putAttribute(IDREF_NAME, string);
        return element;
    }

    protected void createEpub(File file, File file2, ProgressMonitor progressMonitor) throws CanceledException, IOException {
        File file3 = new File(file, "mimetype");
        EpubStep.creatingFile(file3, progressMonitor);
        FileUtil.saveString("application/epub+zip", file3, "US-ASCII");
        File file4 = new File(new File(file, "META-INF"), "container.xml");
        EpubStep.creatingFile(file4, progressMonitor);
        FileUtil.saveString(CONTAINER_XML, file4, "US-ASCII");
        EpubStep.creatingFile(file2, progressMonitor);
        EpubStep.zipEpub(file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void zipEpub(File file, File file2) throws IOException {
        try (Zip.Archive archive = new Zip.Archive(new ZipOutputStream(new FileOutputStream(file2)));){
            String[] stringArray;
            archive.add(new File(file, "mimetype"), file, true);
            for (String string : stringArray = FileUtil.checkedList(file)) {
                if ("mimetype".equals(string)) continue;
                File file3 = new File(file, string);
                if (file3.isDirectory()) {
                    archive.addAll(file3, null, file);
                    continue;
                }
                archive.add(file3, file);
            }
        }
    }
}

