/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.Console;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.GlobFilter;
import com.xmlmind.util.GlobMatcher;
import com.xmlmind.util.ProgressMonitor;
import com.xmlmind.w2x.processor.CanceledException;
import com.xmlmind.w2x.processor.Msg;
import com.xmlmind.w2x.processor.ProcessStep;
import java.io.File;
import java.util.Map;

public class DeleteFilesStep
extends ProcessStep {
    public DeleteFilesStep(String string) {
        super(string);
    }

    @Override
    public void process(Object[] objectArray, Map<String, String> map, int[] nArray, ProgressMonitor progressMonitor) throws Exception {
        String string = this.getParameter(map, "files", null);
        if (string == null || (string = string.trim()).length() == 0) {
            this.missingParameter("files");
        }
        this.progress(Msg.msg("deleteFilesStep", string), nArray, progressMonitor);
        this.debugParameters(map, progressMonitor);
        File[] fileArray = GlobMatcher.containsGlobChar(string, true) ? GlobFilter.glob(string) : new File[]{new File(string)};
        for (File file : fileArray) {
            if (!file.exists()) continue;
            if (!progressMonitor.message(Msg.msg("deletingFile", file), Console.MessageType.DEBUG)) {
                throw new CanceledException();
            }
            FileUtil.deleteFileOrDir(file);
        }
    }
}

