/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.KeyValuePair;
import com.xmlmind.util.LinearHashtable;
import com.xmlmind.w2x.docx.toxhtml.Util;
import java.util.Arrays;
import java.util.Iterator;

final class CSSRule {
    public final String selector;
    public final LinearHashtable<String, String> properties;
    public static final CSSRule[] EMPTY_LIST = new CSSRule[0];

    public CSSRule(String string) {
        this.selector = string;
        this.properties = new LinearHashtable();
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public String setProperty(String string, String string2) {
        if (string2 == null) {
            return this.properties.remove(string);
        }
        return this.properties.put(string, string2);
    }

    public boolean setProperties(String string) {
        String[] stringArray = Util.splitStyleProps(string);
        return CSSRule.addProperties(stringArray, this.properties);
    }

    public static boolean addProperties(String[] stringArray, LinearHashtable<String, String> linearHashtable) {
        for (String string : stringArray) {
            String string2;
            String string3;
            int n = string.indexOf(58);
            if (n > 0) {
                string3 = string.substring(0, n).trim();
                string2 = string.substring(n + 1).trim();
                if (string3.length() <= 0 || string2.length() <= 0) {
                    return false;
                }
            } else {
                return false;
            }
            linearHashtable.put(string3, string2);
        }
        return true;
    }

    public void merge(CSSRule cSSRule) {
        Iterator<KeyValuePair<String, String>> iterator = cSSRule.properties.entries();
        while (iterator.hasNext()) {
            KeyValuePair<String, String> keyValuePair = iterator.next();
            this.properties.put((String)keyValuePair.key, (String)keyValuePair.value);
        }
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append(this.selector);
        stringBuilder.append(" {\n");
        CSSRule.toString(this.properties, '\n', stringBuilder);
        stringBuilder.append("\n}");
    }

    public static void toString(LinearHashtable<String, String> linearHashtable, char c, StringBuilder stringBuilder) {
        int n = linearHashtable.size();
        Object[] objectArray = new String[n];
        n = 0;
        StringBuilder stringBuilder2 = new StringBuilder();
        Iterator<KeyValuePair<String, String>> iterator = linearHashtable.entries();
        while (iterator.hasNext()) {
            KeyValuePair<String, String> keyValuePair = iterator.next();
            stringBuilder2.setLength(0);
            stringBuilder2.append((String)keyValuePair.key);
            stringBuilder2.append(": ");
            stringBuilder2.append((String)keyValuePair.value);
            objectArray[n++] = stringBuilder2.toString();
        }
        if (n > 1) {
            Arrays.sort(objectArray);
        }
        boolean bl = c == '\n';
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(c);
            }
            if (bl) {
                stringBuilder.append("    ");
            }
            stringBuilder.append((String)objectArray[i]);
            stringBuilder.append(';');
        }
    }
}

