/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.w2x.docx.packaging.Part;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.PrefixPreferences;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Theme {
    private final Matcher hexColorMatcher;
    private final HashMap<String, String> fontFamilies;
    private final HashMap<String, String> colors;
    private static final String[] NAMED_COLOR_LIST = new String[]{"black", "#000000", "blue", "#0000FF", "cyan", "#00FFFF", "green", "#00FF00", "magenta", "#FF00FF", "red", "#FF0000", "yellow", "#FFFF00", "white", "#FFFFFF", "darkBlue", "#00008B", "darkCyan", "#008B8B", "darkGreen", "#006400", "darkMagenta", "#800080", "darkRed", "#8B0000", "darkYellow", "#808000", "darkGray", "#A9A9A9", "lightGray", "#D3D3D3"};
    private static final HashMap<String, String> NAMED_COLORS = new HashMap();
    private static final String[] QNAMES;
    private Name name_a_themeElements;
    private Name name_a_clrScheme;
    private Name name_a_fontScheme;
    private Name name_a_majorFont;
    private Name name_a_minorFont;
    private Name name_a_latin;
    private Name name_a_srgbClr;

    public Theme(Part part, int n) throws IOException {
        this.initialize(n);
        this.hexColorMatcher = Pattern.compile("[0-9a-fA-F]{6,6}").matcher("");
        this.fontFamilies = new HashMap();
        this.colors = new HashMap();
        if (part != null) {
            Document document = part.getDocument();
            Util.setPartProperty(document, part);
            Element element = Util.findDescendant(document.getRootElement(), this.name_a_themeElements, false);
            if (element != null) {
                Element element2;
                Element element3 = Util.findDescendant(element, this.name_a_clrScheme, false);
                if (element3 != null) {
                    this.loadColors(element3, this.colors);
                }
                if ((element2 = Util.findDescendant(element, this.name_a_fontScheme, false)) != null) {
                    this.loadFontFamilies(element2, this.fontFamilies);
                }
            }
        }
    }

    private void initialize(int n) {
        PrefixPreferences prefixPreferences = Util.createPrefixPreferences(n);
        try {
            for (String string : QNAMES) {
                Name name = Name.parse(string, true, prefixPreferences);
                if (name == null) {
                    throw new RuntimeException("'" + string + "', not a Name");
                }
                String string2 = "name_" + string.replace(':', '_');
                Field field = Theme.class.getDeclaredField(string2);
                field.set(this, name);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadColors(Element element, Map<String, String> map) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            Element element2;
            Element element3;
            if (node.getType() != Node.Type.ELEMENT || (element3 = Util.findDescendant(element2 = (Element)node, this.name_a_srgbClr, false)) == null || (string = element3.getAttribute(Constants.VAL_ATTR)) == null) continue;
            map.put(element2.getLocalName(), string);
        }
    }

    private void loadFontFamilies(Element element, Map<String, String> map) {
        String string;
        Element element2 = Util.findDescendant(element, this.name_a_majorFont, this.name_a_latin);
        if (element2 != null && (string = element2.getAttribute(Constants.TYPEFACE_ATTR)) != null) {
            map.put("majorAscii", string);
            map.put("majorHAnsi", string);
        }
        if ((element2 = Util.findDescendant(element, this.name_a_minorFont, this.name_a_latin)) != null && (string = element2.getAttribute(Constants.TYPEFACE_ATTR)) != null) {
            map.put("minorAscii", string);
            map.put("minorHAnsi", string);
        }
    }

    public String getFontFamily(Element element, Name name, Name name2) {
        String string = null;
        if (name != null && (string = element.getAttribute(name)) != null) {
            string = this.fontFamilies.get(string);
        }
        if (string == null && name2 != null) {
            string = element.getAttribute(name2);
        }
        return string;
    }

    public String getColor(Element element, Name name, Name name2, Name name3, Name name4) {
        String string = null;
        boolean bl = true;
        if (name4 != null) {
            string = element.getAttribute(name4);
        }
        if (string == null && name != null && (string = element.getAttribute(name)) != null && (string = this.colors.get(string)) != null) {
            int n;
            int n2 = -1;
            if (name2 != null && (n2 = Theme.getColorShade(element, name2)) >= 0) {
                boolean bl2 = bl = (string = Theme.applyShade(string, n2)) != null;
            }
            if (n2 < 0 && name3 != null && (n = Theme.getColorShade(element, name3)) >= 0) {
                boolean bl3 = bl = (string = Theme.applyTint(string, n)) != null;
            }
        }
        if (string != null && bl) {
            string = this.parseColor(string);
        }
        return string;
    }

    private static int getColorShade(Element element, Name name) {
        int n = -1;
        String string = element.getAttribute(name);
        if (string != null) {
            try {
                n = Integer.parseInt(string, 16);
                if (n < 0 || n > 255) {
                    n = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private static String applyShade(String string, int n) {
        int[] nArray = Theme.parseHexColor(string);
        if (nArray == null) {
            return null;
        }
        nArray[0] = Theme.applyShade(nArray[0], n);
        nArray[1] = Theme.applyShade(nArray[1], n);
        nArray[2] = Theme.applyShade(nArray[2], n);
        return Theme.formatHexColor(nArray);
    }

    private static int[] parseHexColor(String string) {
        int[] nArray = new int[3];
        if (string.length() == 6) {
            try {
                nArray[0] = Integer.parseInt(string.substring(0, 2), 16);
                nArray[1] = Integer.parseInt(string.substring(2, 4), 16);
                nArray[2] = Integer.parseInt(string.substring(4, 6), 16);
            }
            catch (NumberFormatException numberFormatException) {
                nArray = null;
            }
        }
        return nArray;
    }

    private static int applyShade(int n, int n2) {
        if ((n = n2 * n / 255) < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return n;
    }

    public static String formatHexColor(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Integer.toHexString(nArray[0]);
        if (string.length() < 2) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string.toUpperCase());
        string = Integer.toHexString(nArray[1]);
        if (string.length() < 2) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string.toUpperCase());
        string = Integer.toHexString(nArray[2]);
        if (string.length() < 2) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string.toUpperCase());
        return stringBuilder.toString();
    }

    private static String applyTint(String string, int n) {
        int[] nArray = Theme.parseHexColor(string);
        if (nArray == null) {
            return null;
        }
        nArray[0] = Theme.applyTint(nArray[0], n);
        nArray[1] = Theme.applyTint(nArray[1], n);
        nArray[2] = Theme.applyTint(nArray[2], n);
        return Theme.formatHexColor(nArray);
    }

    private static int applyTint(int n, int n2) {
        if ((n = (255 - n2) * (255 - n) / 255 + n) < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return n;
    }

    private String parseColor(String string) {
        if ("auto".equals(string)) {
            return "#000000";
        }
        this.hexColorMatcher.reset(string);
        if (this.hexColorMatcher.matches()) {
            return "#" + string.toUpperCase();
        }
        return NAMED_COLORS.get(string);
    }

    static {
        for (int i = 0; i < NAMED_COLOR_LIST.length; i += 2) {
            NAMED_COLORS.put(NAMED_COLOR_LIST[i], NAMED_COLOR_LIST[i + 1]);
        }
        QNAMES = new String[]{"a:themeElements", "a:clrScheme", "a:fontScheme", "a:majorFont", "a:minorFont", "a:latin", "a:srgbClr"};
    }
}

