/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.w2x.docx.toxhtml.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

final class TabStop
implements Comparable<TabStop> {
    public final String val;
    public final double pos;
    public final String leader;
    public static final TabStop[] EMPTY_LIST = new TabStop[0];

    public TabStop(String string, String string2, String string3) {
        this(string, TabStop.parsePos(string2), string3);
    }

    private static double parsePos(String string) {
        double d = 0.0;
        if (string != null && string.endsWith("pt")) {
            try {
                d = Double.parseDouble(string.substring(0, string.length() - 2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    public TabStop(String string, double d, String string2) {
        this.val = string;
        this.pos = d;
        this.leader = string2;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.pos);
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TabStop)) {
            return false;
        }
        return this.pos == ((TabStop)object).pos;
    }

    @Override
    public int compareTo(TabStop tabStop) {
        double d = this.pos - tabStop.pos;
        if (d < 0.0) {
            return -1;
        }
        if (d > 0.0) {
            return 1;
        }
        return 0;
    }

    public static TabStop[] getFromProperties(Map<String, String> map) {
        return TabStop.listFromProperties(false, map);
    }

    public static TabStop[] removeFromProperties(Map<String, String> map) {
        return TabStop.listFromProperties(true, map);
    }

    private static TabStop[] listFromProperties(boolean bl, Map<String, String> map) {
        ArrayList<TabStop> arrayList = new ArrayList<TabStop>();
        for (int i = 0; i < 100; ++i) {
            String string = "-ms-tab" + Integer.toString(i);
            String string2 = bl ? map.remove(string) : map.get(string);
            if (string2 == null) break;
            String string3 = bl ? map.remove(string + "-pos") : map.get(string + "-pos");
            String string4 = bl ? map.remove(string + "-leader") : map.get(string + "-leader");
            TabStop tabStop = new TabStop(string2, string3, string4);
            if (!(tabStop.pos > 0.0)) continue;
            arrayList.add(tabStop);
        }
        return arrayList.toArray(EMPTY_LIST);
    }

    public static TabStop[] merge(TabStop[] tabStopArray, TabStop[] tabStopArray2) {
        if (tabStopArray.length == 0) {
            return tabStopArray2;
        }
        if (tabStopArray2.length == 0) {
            return tabStopArray;
        }
        HashMap<TabStop, TabStop> hashMap = new HashMap<TabStop, TabStop>();
        for (TabStop tabStop : tabStopArray) {
            hashMap.put(tabStop, tabStop);
        }
        for (TabStop tabStop : tabStopArray2) {
            hashMap.put(tabStop, tabStop);
        }
        Object[] objectArray = new TabStop[hashMap.size()];
        hashMap.values().toArray(objectArray);
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    public static void addToProperties(TabStop[] tabStopArray, Map<String, String> map) {
        int n = tabStopArray.length;
        if (n > 1) {
            Arrays.sort(tabStopArray);
        }
        for (int i = 0; i < n; ++i) {
            TabStop tabStop = tabStopArray[i];
            String string = "-ms-tab" + Integer.toString(i);
            map.put(string, tabStop.val);
            map.put(string + "-pos", Util.formatDouble(tabStop.pos) + "pt");
            if (tabStop.leader == null) continue;
            map.put(string + "-leader", tabStop.leader);
        }
    }
}

