/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.Text;
import java.util.Stack;

final class SimplifyFields {
    SimplifyFields() {
    }

    public static void process(Document document) {
        Element element = document.getRootElement();
        Element element2 = Util.findDescendant(element, Constants.BODY_ELEM, false);
        if (element2 == null) {
            return;
        }
        Stack<ComplexField> stack = new Stack<ComplexField>();
        int[] nArray = new int[1];
        SimplifyFields.simplify(element2, stack, nArray);
    }

    private static void simplify(Element element, Stack<ComplexField> stack, int[] nArray) {
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getType() == Node.Type.ELEMENT) {
                Element element2 = (Element)node;
                if (element2.getName() == Constants.SPAN_ELEM) {
                    Node node3 = SimplifyFields.getFirstChild(element2);
                    if (node3 != null && node3.getType() == Node.Type.PROCESSING_INSTRUCTION) {
                        ComplexField complexField;
                        ProcessingInstruction processingInstruction = (ProcessingInstruction)node3;
                        String string = processingInstruction.getTarget();
                        if ("field-begin".equals(string)) {
                            complexField = new ComplexField(element2);
                            stack.push(complexField);
                        } else if ("field-code".equals(string)) {
                            complexField = SimplifyFields.top(stack);
                            if (complexField == null) {
                                node2 = null;
                            } else {
                                complexField.addCodeSpan(element2);
                                complexField.addFieldCode(processingInstruction.getText());
                            }
                        } else if ("field-separate".equals(string)) {
                            complexField = SimplifyFields.top(stack);
                            if (complexField == null) {
                                node2 = null;
                            } else {
                                complexField.separateSpan = element2;
                            }
                        } else if ("field-end".equals(string)) {
                            complexField = SimplifyFields.top(stack);
                            if (complexField == null) {
                                node2 = null;
                            } else {
                                complexField.endSpan = element2;
                                stack.pop();
                                ComplexField complexField2 = SimplifyFields.top(stack);
                                if (complexField2 == null) {
                                    complexField.simplify(nArray);
                                } else if (complexField2.separateSpan == null) {
                                    complexField2.addFieldCode(complexField.fieldCode.toString());
                                    complexField.delete();
                                } else {
                                    complexField.simplify(nArray);
                                }
                            }
                        }
                    }
                } else {
                    SimplifyFields.simplify(element2, stack, nArray);
                }
            }
            node = node2;
        }
    }

    static Node getFirstChild(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() == Node.Type.TEXT && ((Text)node).isXMLSpace()) continue;
            return node;
        }
        return null;
    }

    private static ComplexField top(Stack<ComplexField> stack) {
        return stack.empty() ? null : stack.peek();
    }

    private static final class ComplexField {
        public final Element beginSpan;
        public Element[] codeSpans;
        public StringBuilder fieldCode;
        public Element separateSpan;
        public Element endSpan;

        public ComplexField(Element element) {
            this.beginSpan = element;
            this.fieldCode = new StringBuilder();
        }

        public void addCodeSpan(Element element) {
            this.codeSpans = this.codeSpans == null ? new Element[]{element} : ArrayUtil.append(this.codeSpans, element);
        }

        public void addFieldCode(String string) {
            if (string != null && string.length() > 0) {
                this.fieldCode.append(string);
            }
        }

        public void simplify(int[] nArray) {
            Element element;
            if (this.beginSpan == null || this.codeSpans == null || this.fieldCode.length() == 0 || this.endSpan == null) {
                return;
            }
            Element element2 = this.beginSpan.getParentElement();
            if (element2 == (element = this.endSpan.getParentElement())) {
                Node node;
                Element element3 = new Element(Constants.SPAN_ELEM);
                String string = Util.normalizeFieldCode(this.fieldCode.toString());
                if (string.length() > 0) {
                    string = Util.processFieldCodeIdref(string, null);
                    element3.putAttribute(Constants.CLASS_ATTR, "role-field");
                    node = new ProcessingInstruction("field", string);
                    element3.appendChild(node);
                }
                if (this.separateSpan != null) {
                    node = this.separateSpan.getNextSibling();
                    while (node != null && node != this.endSpan) {
                        Node node2 = node.getNextSibling();
                        element2.removeChild(node);
                        element3.appendChild(node);
                        node = node2;
                    }
                }
                element2.insertChild(this.beginSpan, element3);
                this.delete();
            } else {
                String string = Util.normalizeFieldCode(this.fieldCode.toString());
                if (string.length() > 0) {
                    string = Util.processFieldCodeIdref(string, null);
                }
                int n = nArray[0];
                nArray[0] = n + 1;
                int n2 = n;
                ProcessingInstruction processingInstruction = new ProcessingInstruction("begin-field", "#" + n2 + " " + string);
                element2.replaceChild(this.beginSpan, processingInstruction);
                for (Element element4 : this.codeSpans) {
                    element4.getParent().removeChild(element4);
                }
                if (this.separateSpan != null) {
                    this.separateSpan.getParent().removeChild(this.separateSpan);
                }
                processingInstruction = new ProcessingInstruction("end-field", "#" + n2);
                element.replaceChild(this.endSpan, processingInstruction);
            }
        }

        public void delete() {
            Element element = this.beginSpan.getParentElement();
            Node node = this.beginSpan;
            while (node != null) {
                Node node2 = node.getNextSibling();
                element.removeChild(node);
                if (node == this.endSpan) break;
                node = node2;
            }
        }
    }
}

