/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.util.ObjectUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.w2x.docx.toxhtml.LegacyFontMappings;
import com.xmlmind.w2x.docx.toxhtml.Style;
import com.xmlmind.w2x.docx.toxhtml.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class Numbering
extends Style {
    public final HashMap<String, String> propsBefore = new HashMap();
    public final HashMap<String, String> paragraphProps = new HashMap();
    public static final Numbering NO_NUMBERING = new Numbering("n-0-0");

    public Numbering(String string) {
        super(string);
    }

    public void finishTranslation(Map<String, Style> map) {
        Object object;
        String[] stringArray;
        String string;
        int n = this.getLevel();
        if (n < 0) {
            return;
        }
        Object object2 = null;
        String string2 = (String)this.props.get("-ms-lvlPicBullet");
        if (string2 != null) {
            object2 = string2;
        } else {
            string = this.getLvlText();
            if (string != null && string.length() > 0) {
                object2 = this.parseLvlText(string, n, map);
            }
        }
        string = (String)this.props.get("-ms-suff");
        if (string == null) {
            string = "tab";
        }
        if ("tab".equals(string)) {
            stringArray = new String[2];
            object = this.findNumberedStyle(map, stringArray);
            if (stringArray[0] == null) {
                stringArray[0] = this.paragraphProps.get("margin-left");
            }
            if (stringArray[1] == null) {
                stringArray[1] = this.paragraphProps.get("text-indent");
            }
            double d = Numbering.parsePt(stringArray[0]);
            double d2 = Numbering.parsePt(stringArray[1]);
            if (!Double.isNaN(d2)) {
                d2 = -d2;
            }
            double d3 = Double.NaN;
            ArrayList<Tab> arrayList = new ArrayList<Tab>();
            Numbering.getTabs(this.paragraphProps, arrayList);
            if (object != null) {
                Numbering.getTabs(((Style)object).props, arrayList);
            }
            if (arrayList.size() > 0) {
                if (arrayList.size() > 1) {
                    Collections.sort(arrayList);
                }
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    Tab tab = arrayList.get(i);
                    if (tab.remove) {
                        arrayList.remove(i);
                        continue;
                    }
                    if (!"clear".equals(tab.align)) continue;
                    Tab tab2 = null;
                    if (i - 1 >= 0) {
                        tab2 = arrayList.get(i - 1);
                    }
                    if (tab2 != null && !"clear".equals(tab2.align) && tab2.pos == tab.pos) {
                        tab2.remove = true;
                    }
                    arrayList.remove(i);
                }
            }
            if (arrayList.size() > 0) {
                Tab tab = arrayList.get(0);
                if ("num".equals(tab.align)) {
                    d3 = arrayList.get((int)0).pos;
                }
            }
            double d4 = Double.NaN;
            if (!Double.isNaN(d3) && d3 > 0.0 && !Double.isNaN(d) && d > 0.0 && !Double.isNaN(d2) && d2 > 0.0) {
                d4 = d3 - (d - d2);
            }
            if (Double.isNaN(d4) || d4 <= 0.0) {
                d4 = d2;
            }
            if (!Double.isNaN(d4) && d4 > 0.0) {
                this.propsBefore.put("float", "left");
                this.propsBefore.put("width", Util.formatDouble(d4) + "pt");
            } else {
                string = "space";
            }
        }
        if (object2 != null) {
            if ("space".equals(string)) {
                object2 = ((String)object2).endsWith("\"") ? ((String)object2).substring(0, ((String)object2).length() - 1) + " \"" : (String)object2 + " \" \"";
            }
            this.propsBefore.put("content", (String)object2);
        }
        if ((stringArray = this.getCounterIncrement()) != null) {
            this.propsBefore.put("counter-increment", (String)stringArray);
        }
        if ((object = this.collectRestarts(map, n)) != null) {
            this.props.put("counter-reset", object);
        }
    }

    private Style findNumberedStyle(Map<String, Style> map, String[] stringArray) {
        Style style = null;
        for (Style style2 : map.values()) {
            if (!style2.name.startsWith("p-") || !this.name.equals(style2.get("-ms-numPr"))) continue;
            if (style == null) {
                style = style2;
                stringArray[0] = style2.get("margin-left");
                stringArray[1] = style2.get("text-indent");
                continue;
            }
            if (ObjectUtil.equals(style2.get("margin-left"), stringArray[0]) && ObjectUtil.equals(style2.get("text-indent"), stringArray[1])) continue;
            style = null;
            break;
        }
        return style;
    }

    private static void getTabs(Map<String, String> map, List<Tab> list) {
        String string;
        String string2;
        for (int i = 0; i < 100 && (string2 = map.get(string = "-ms-tab" + Integer.toString(i))) != null; ++i) {
            double d = Numbering.parsePt(map.get(string + "-pos"));
            if (Double.isNaN(d)) continue;
            list.add(new Tab(d, string2));
        }
    }

    private static double parsePt(String string) {
        double d = Double.NaN;
        if (string != null && string.endsWith("pt")) {
            try {
                d = Double.parseDouble(string.substring(0, string.length() - 2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    public int getLevel() {
        int n = -1;
        int n2 = this.name.lastIndexOf(45);
        if (n2 >= 0) {
            try {
                n = Integer.parseInt(this.name.substring(n2 + 1));
                if (n < 0 || n > 9) {
                    n = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private String getLvlText() {
        String string = (String)this.props.get("-ms-lvlText");
        if (string != null && string.startsWith("\"")) {
            int n;
            if ((string = StringUtil.unquote(string)).length() == 1 && "bullet".equals(this.props.get("-ms-numFmt")) && (n = string.charAt(0)) >= 61440) {
                n -= 61440;
                String string2 = this.propsBefore.get("font-family");
                if (string2 != null && (n = LegacyFontMappings.map(string2, n)) > 0) {
                    string = Character.toString((char)n);
                    this.propsBefore.remove("font-family");
                    this.props.put("-ms-lvlText-font-family", string2);
                }
            }
        } else {
            string = null;
        }
        return string;
    }

    private String parseLvlText(String string, int n, Map<String, Style> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        int n2 = string.length();
        block6: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block6;
                }
                case '%': {
                    if (i + 1 < n2) {
                        int n3;
                        for (n3 = i + 1; n3 < n2 && Character.isDigit(string.charAt(n3)); ++n3) {
                        }
                        if (n3 > i + 1) {
                            int n4 = -1;
                            try {
                                n4 = Integer.parseInt(string.substring(i + 1, n3)) - 1;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (n4 >= 0 && n4 <= n) {
                                String string2 = null;
                                if (n4 == n) {
                                    string2 = this.getCounter(this.isLgl());
                                } else {
                                    Numbering numbering = this.getNumbering(map, n4);
                                    if (numbering != null) {
                                        string2 = numbering.getCounter(this.isLgl());
                                    }
                                }
                                if (string2 != null) {
                                    if (string2.startsWith("counter(")) {
                                        stringBuilder.append("\" ");
                                        stringBuilder.append(string2);
                                        stringBuilder.append(" \"");
                                    } else {
                                        stringBuilder.append(string2);
                                    }
                                    i = n3 - 1;
                                    continue block6;
                                }
                            }
                        }
                    }
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        stringBuilder.append('\"');
        String string3 = stringBuilder.toString();
        string3 = string3.replaceAll("\\s*\"\"\\s*", " ");
        string3 = string3.trim();
        return string3;
    }

    private boolean isLgl() {
        return "true".equals(this.props.get("-ms-isLgl"));
    }

    private String getCounter(boolean bl) {
        String string = this.getCounterFormat(bl);
        if (string == null) {
            return this.getLvlText();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("counter(");
        stringBuilder.append(this.name);
        if (!"decimal".equals(string)) {
            stringBuilder.append(", ");
            stringBuilder.append(string);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private String getCounterFormat(boolean bl) {
        String string = (String)this.props.get("-ms-numFmt");
        if (string == null) {
            string = "decimal";
        }
        if ("bullet".equals(string) || "none".equals(string)) {
            return null;
        }
        if (bl && !string.startsWith("decimal")) {
            string = "decimal";
        }
        String string2 = "decimal";
        if ("lowerLetter".equals(string)) {
            string2 = "lower-alpha";
        } else if ("upperLetter".equals(string)) {
            string2 = "upper-alpha";
        } else if ("lowerRoman".equals(string)) {
            string2 = "lower-roman";
        } else if ("upperRoman".equals(string)) {
            string2 = "upper-roman";
        } else if ("decimalZero".equals(string)) {
            string2 = "decimal-leading-zero";
        }
        return string2;
    }

    public boolean hasCounter() {
        return this.getCounterFormat(false) != null;
    }

    public Numbering getNumbering(Map<String, Style> map, int n) {
        int n2 = this.name.lastIndexOf(45);
        if (n2 < 0) {
            return null;
        }
        String string = this.name.substring(0, n2 + 1) + Integer.toString(n);
        return (Numbering)map.get(string);
    }

    private String getCounterIncrement() {
        if (!this.hasCounter()) {
            return null;
        }
        return this.name;
    }

    private String collectRestarts(Map<String, Style> map, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n + 1; i <= 9; ++i) {
            int n2;
            String string;
            Numbering numbering = this.getNumbering(map, i);
            if (numbering == null || (string = numbering.getCounterReset()) == null || (n2 = numbering.getRestart()) < 0 || n2 > n) continue;
            stringBuilder.append(' ');
            stringBuilder.append(string);
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString().trim();
    }

    private String getCounterReset() {
        if (!this.hasCounter()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append(' ');
        stringBuilder.append(Integer.toString(this.getStart() - 1));
        return stringBuilder.toString();
    }

    public int getStart() {
        int n = 0;
        String string = (String)this.props.get("-ms-start");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private int getRestart() {
        int n = this.getLevel();
        if (n <= 0) {
            return -1;
        }
        int n2 = n - 1;
        String string = (String)this.props.get("-ms-lvlRestart");
        if (string != null) {
            try {
                n2 = Integer.parseInt(string) - 1;
                if (n2 < -1 || n2 >= n) {
                    n2 = n - 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static boolean splitName(String string, int[] nArray) {
        nArray[1] = -1;
        nArray[0] = -1;
        int n = string.indexOf(45);
        if (n < 0) {
            return false;
        }
        int n2 = string.indexOf(45, ++n);
        try {
            if (n2 < 0) {
                nArray[0] = Integer.parseInt(string.substring(n));
            } else {
                nArray[0] = Integer.parseInt(string.substring(n, n2));
                nArray[1] = Integer.parseInt(string.substring(n2 + 1));
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static final class Tab
    implements Comparable<Tab> {
        public final double pos;
        public final String align;
        public boolean remove;

        public Tab(double d, String string) {
            this.pos = d;
            this.align = string;
        }

        @Override
        public int compareTo(Tab tab) {
            double d = this.pos - tab.pos;
            if (d < 0.0) {
                return -1;
            }
            if (d > 0.0) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Tab[pos=");
            stringBuilder.append(this.pos);
            stringBuilder.append(", align=");
            stringBuilder.append(this.align);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

