/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.util.StringUtil;
import com.xmlmind.util.URLUtil;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;

final class LegacyFontMappings {
    private static final HashMap<String, int[]> maps = new HashMap();

    private LegacyFontMappings() {
    }

    public static int map(String string, int n) {
        if (n < 0 || n > 255) {
            return 0;
        }
        int n2 = 0;
        if ("symbol".equals(string = string.toLowerCase())) {
            int[] nArray = LegacyFontMappings.getMap("Symbol");
            n2 = nArray[n];
        } else if ("wingdings 3".equals(string)) {
            int[] nArray = LegacyFontMappings.getMap("Wingdings3");
            n2 = nArray[n];
        } else if ("wingdings 2".equals(string)) {
            int[] nArray = LegacyFontMappings.getMap("Wingdings2");
            n2 = nArray[n];
        } else if ("wingdings".equals(string)) {
            int[] nArray = LegacyFontMappings.getMap("Wingdings");
            n2 = nArray[n];
        } else if (string.indexOf("dingbats") >= 0) {
            int[] nArray = LegacyFontMappings.getMap("ZapfDingbats");
            n2 = nArray[n];
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getMap(String string) {
        HashMap<String, int[]> hashMap = maps;
        synchronized (hashMap) {
            int[] nArray = maps.get(string);
            if (nArray == null) {
                try {
                    nArray = LegacyFontMappings.loadMap(string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (nArray == null) {
                    nArray = new int[255];
                }
                maps.put(string, nArray);
            }
            return nArray;
        }
    }

    private static int[] loadMap(String string) throws IOException {
        int[] nArray = null;
        URL uRL = LegacyFontMappings.class.getResource("legacy_font_mapping/" + string + ".map");
        if (uRL != null) {
            String string2 = URLUtil.loadString(uRL, "US-ASCII");
            String[] stringArray = StringUtil.split(string2, '\n');
            nArray = new int[255];
            for (String string3 : stringArray) {
                String[] stringArray2;
                if ((string3 = string3.trim()).length() == 0 || string3.charAt(0) == '#' || (stringArray2 = StringUtil.split(string3, '\t')).length < 2) continue;
                int n = -1;
                int n2 = -1;
                try {
                    n = Integer.parseInt(stringArray2[0], 16);
                    n2 = Integer.parseInt(stringArray2[1], 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n2 < 0 || n2 >= 255 || n < 0 || n >= 57344) continue;
                nArray[n2] = n;
            }
        }
        return nArray;
    }
}

