/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.packaging;

import com.xmlmind.util.StringUtil;
import com.xmlmind.util.URIComponent;
import com.xmlmind.w2x.docx.packaging.Msg;
import java.net.URI;

public final class PartNameUtil {
    private PartNameUtil() {
    }

    public static String partNameToSystemId(URI uRI, String string) {
        StringBuilder stringBuilder = new StringBuilder("zip:");
        stringBuilder.append(uRI.toASCIIString());
        stringBuilder.append('!');
        stringBuilder.append(URIComponent.quoteFullPath(string));
        return stringBuilder.toString();
    }

    public static String zipToPartName(String object) {
        if (!((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        return object;
    }

    public static String extension(String string) {
        return URIComponent.getRawExtension(string);
    }

    public static String parent(String string) {
        return URIComponent.getRawParentPath(string, false);
    }

    public static String baseName(String string) {
        return URIComponent.getRawBaseName(string);
    }

    public static String resolve(String string, String string2) throws IllegalArgumentException {
        if ((string = PartNameUtil.fix(string)).startsWith("/")) {
            return PartNameUtil.normalize(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string2.endsWith("/")) {
            stringBuilder.append(string2);
        } else {
            stringBuilder.append(PartNameUtil.parent(string2));
            stringBuilder.append('/');
        }
        stringBuilder.append(string);
        return PartNameUtil.normalize(stringBuilder.toString());
    }

    public static String fix(String string) {
        if (string.indexOf(92) >= 0) {
            string = string.replace('\\', '/');
        }
        return URIComponent.encode(string);
    }

    public static String normalize(String string) throws IllegalArgumentException {
        int n;
        if (string == null || string.length() == 0 || string.charAt(0) != '/') {
            throw new IllegalArgumentException(Msg.msg("emptyOrRelativePath", string));
        }
        int n2 = string.length() - 1;
        for (n = 0; n <= n2 && string.charAt(n) == '/'; ++n) {
        }
        while (n2 >= n && string.charAt(n2) == '/') {
            --n2;
        }
        if (n > n2) {
            return "/";
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : StringUtil.split(string.substring(n, n2 + 1), '/')) {
            if (string2.length() == 0 || ".".equals(string2)) continue;
            if ("..".equals(string2)) {
                bl = true;
            } else if (!PartNameUtil.isValidSegment(string2)) {
                throw new IllegalArgumentException(Msg.msg("invalidPathSegment", string2, string));
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append('/');
            }
            stringBuilder.append(string2);
        }
        if (bl) {
            String[] stringArray = StringUtil.split(stringBuilder.toString(), '/');
            int n3 = stringArray.length;
            stringBuilder = new StringBuilder();
            for (int i = n3 - 1; i >= 0; --i) {
                String string2;
                string2 = stringArray[i];
                if ("..".equals(string2)) {
                    int n4;
                    for (n4 = i; n4 >= 0 && "..".equals(stringArray[n4]); --n4) {
                    }
                    if ((i = i - 2 * (i - n4) + 1) >= 0) continue;
                    throw new IllegalArgumentException(Msg.msg("invalidPath", string));
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.insert(0, '/');
                }
                stringBuilder.insert(0, string2);
            }
        }
        stringBuilder.insert(0, '/');
        return stringBuilder.toString();
    }

    private static boolean isValidSegment(String string) {
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c) || c == '.') continue;
            bl = true;
            break;
        }
        return bl;
    }
}

