/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import java.util.HashMap;
import java.util.Locale;

public final class LocaleUtil {
    private static HashMap<String, Locale> langToLocale = new HashMap();
    private static final String[] INDIVIDUAL_LANGUAGES = new String[]{"no", "NO", "", "nb", "no", "NO", "NY", "nn"};

    private LocaleUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale getLocale(String string) {
        string = LocaleUtil.normalizeLang(string);
        HashMap<String, Locale> hashMap = langToLocale;
        synchronized (hashMap) {
            Locale locale = langToLocale.get(string);
            if (locale == null) {
                locale = LocaleUtil.createLocale(string);
                langToLocale.put(string, locale);
            }
            return locale;
        }
    }

    public static String normalizeLang(String string) {
        return LocaleUtil.normalizeLang(string, null);
    }

    public static String normalizeLang(String string, String[] stringArray) {
        if (string == null || (string = string.trim()).length() == 0) {
            return string;
        }
        String[] stringArray2 = string.split("[-_]");
        if (stringArray2.length >= 2) {
            String string2 = stringArray2[0].toLowerCase(Locale.US);
            String string3 = stringArray2[1].toUpperCase(Locale.US);
            if (stringArray != null) {
                stringArray[0] = string2;
                stringArray[1] = string3;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append('-');
            stringBuilder.append(string3);
            return stringBuilder.toString();
        }
        String string4 = string.toLowerCase(Locale.US);
        if (stringArray != null) {
            stringArray[0] = string4;
            stringArray[1] = null;
        }
        return string4;
    }

    private static Locale createLocale(String string) {
        int n = string.indexOf(45);
        if (n < 0) {
            return new Locale(string);
        }
        return new Locale(string.substring(0, n), string.substring(n + 1));
    }

    public static String getIndividualLanguageCode(Locale locale) {
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        string2 = string2 == null ? "" : string2.toUpperCase();
        String string3 = locale.getVariant();
        string3 = string3 == null ? "" : string3.toUpperCase();
        int n = INDIVIDUAL_LANGUAGES.length;
        for (int i = 0; i < n; i += 4) {
            if (!string.equals(INDIVIDUAL_LANGUAGES[i]) || !string2.equals(INDIVIDUAL_LANGUAGES[i + 1]) || !string3.equals(INDIVIDUAL_LANGUAGES[i + 2])) continue;
            return INDIVIDUAL_LANGUAGES[i + 3];
        }
        return string;
    }
}

