/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.SystemUtil;
import com.xmlmind.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LoadText {
    public static final XMLEncodingDetector XML_ENCODING_DETECTOR = new XMLEncodingDetector();
    public static final KeywordBasedDetector CSS_CHARSET_DETECTOR = new KeywordBasedDetector("@charset");
    public static final HTMLCharsetDetector HTML_CHARSET_DETECTOR = new HTMLCharsetDetector();
    public static final EmacsStyleDetector EMACS_STYLE_DETECTOR = new EmacsStyleDetector();
    public static final EncodingDetector[] ALL_ENCODING_DETECTORS = new EncodingDetector[]{XML_ENCODING_DETECTOR, HTML_CHARSET_DETECTOR, CSS_CHARSET_DETECTOR, EMACS_STYLE_DETECTOR};
    public static final byte[] BOM_UTF16_BE = new byte[]{-2, -1};
    public static final byte[] BOM_UTF16_LE = new byte[]{-1, -2};
    public static final byte[] BOM_UTF8 = new byte[]{-17, -69, -65};

    private LoadText() {
    }

    public static String loadText(File file, String string, String[] stringArray, EncodingDetector ... encodingDetectorArray) throws IOException {
        return LoadText.loadText(FileUtil.fileToURL(file), true, -1, string, stringArray, encodingDetectorArray);
    }

    public static String loadText(URL uRL, String string, String[] stringArray, EncodingDetector ... encodingDetectorArray) throws IOException {
        return LoadText.loadText(uRL, true, -1, string, stringArray, encodingDetectorArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadText(URL uRL, boolean bl, int n, String string, String[] stringArray, EncodingDetector ... encodingDetectorArray) throws IOException {
        String string2;
        URLConnection uRLConnection = URLUtil.openConnectionNoCache(uRL);
        if (n >= 0) {
            uRLConnection.setConnectTimeout(n);
            uRLConnection.setReadTimeout(n);
        }
        uRLConnection = URLUtil.checkHttpConnection(uRLConnection, bl);
        if (string == null && (string2 = uRLConnection.getContentType()) != null) {
            string = URLUtil.contentTypeToCharset(string2);
        }
        string2 = null;
        try (InputStream inputStream = uRLConnection.getInputStream();){
            string2 = LoadText.loadText(inputStream, string, stringArray, encodingDetectorArray);
        }
        return string2;
    }

    public static String loadText(InputStream inputStream, String string, String[] stringArray, EncodingDetector ... encodingDetectorArray) throws IOException {
        Reader reader = LoadText.createReader(inputStream, string, stringArray, encodingDetectorArray);
        return LoadText.loadChars(reader);
    }

    public static String loadChars(Reader reader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[65536];
        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
            if (n <= 0) continue;
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public static Reader createReader(InputStream inputStream, String string, String[] stringArray, EncodingDetector ... encodingDetectorArray) throws IOException {
        byte[] byArray = new byte[32768];
        int n = -1;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, byArray.length);
        try {
            int n2 = pushbackInputStream.read(byArray, 0, byArray.length);
            if (n2 > 0) {
                pushbackInputStream.unread(byArray, 0, n2);
            }
            n = n2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int[] nArray = new int[1];
        String string2 = LoadText.detectEncoding(byArray, n, nArray, encodingDetectorArray);
        if (nArray[0] > 0) {
            pushbackInputStream.skip(nArray[0]);
        }
        if (string2 == null && (string2 = string) == null) {
            string2 = SystemUtil.defaultEncoding();
        }
        if (stringArray != null) {
            stringArray[0] = string2;
        }
        return new InputStreamReader((InputStream)pushbackInputStream, string2);
    }

    public static final String checkEncoding(String string) {
        if (string != null) {
            if ((string = string.trim()).length() == 0) {
                string = null;
            } else {
                try {
                    Charset charset = Charset.forName(string);
                    string = charset.name();
                }
                catch (Exception exception) {
                    string = null;
                }
            }
        }
        return string;
    }

    public static String detectEncoding(byte[] byArray, int n, int[] nArray, EncodingDetector ... encodingDetectorArray) {
        if (nArray != null) {
            nArray[0] = 0;
        }
        String string = null;
        Encoding encoding = LoadText.guessEncoding(byArray, 0, n);
        switch (encoding) {
            case UTF16_BE_BOM: {
                if (nArray != null) {
                    nArray[0] = 2;
                }
            }
            case UTF16_BE: {
                string = "UTF-16BE";
                break;
            }
            case UTF16_LE_BOM: {
                if (nArray != null) {
                    nArray[0] = 2;
                }
            }
            case UTF16_LE: {
                string = "UTF-16LE";
                break;
            }
            case UTF8_BOM: {
                if (nArray != null) {
                    nArray[0] = 3;
                }
                string = "UTF-8";
                break;
            }
            case UCS4_BE_BOM: 
            case UCS4_BE: 
            case UCS4_LE_BOM: 
            case UCS4_LE: 
            case UCS4_2143_BOM: 
            case UCS4_2143: 
            case UCS4_3412_BOM: 
            case UCS4_3412: 
            case EBCDIC: {
                return null;
            }
        }
        if (string == null) {
            String string2 = null;
            try {
                string2 = new String(byArray, 0, n, "US-ASCII");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 != null && string2.length() > 0) {
                EncodingDetector encodingDetector;
                EncodingDetector[] encodingDetectorArray2 = encodingDetectorArray;
                int n2 = encodingDetectorArray2.length;
                for (int i = 0; i < n2 && (string = (encodingDetector = encodingDetectorArray2[i]).detectEncoding(string2)) == null; ++i) {
                }
            }
        }
        return string;
    }

    public static Encoding guessEncoding(byte[] byArray, int n, int n2) {
        if (n2 < 4) {
            return Encoding.UNKNOWN;
        }
        int n3 = byArray[n] & 0xFF;
        int n4 = byArray[n + 1] & 0xFF;
        int n5 = byArray[n + 2] & 0xFF;
        int n6 = byArray[n + 3] & 0xFF;
        if (n3 == 0 && n4 == 0 && n5 == 254 && n6 == 255) {
            return Encoding.UCS4_BE_BOM;
        }
        if (n3 == 255 && n4 == 254 && n5 == 0 && n6 == 0) {
            return Encoding.UCS4_LE_BOM;
        }
        if (n3 == 0 && n4 == 0 && n5 == 255 && n6 == 254) {
            return Encoding.UCS4_2143_BOM;
        }
        if (n3 == 254 && n4 == 255 && n5 == 0 && n6 == 0) {
            return Encoding.UCS4_3412_BOM;
        }
        if (n3 == 254 && n4 == 255 && (n5 != 0 || n6 != 0)) {
            return Encoding.UTF16_BE_BOM;
        }
        if (n3 == 255 && n4 == 254 && (n5 != 0 || n6 != 0)) {
            return Encoding.UTF16_LE_BOM;
        }
        if (n3 == 239 && n4 == 187 && n5 == 191) {
            return Encoding.UTF8_BOM;
        }
        if (n3 == 0 && n4 == 0 && n5 == 0 && n6 == 64) {
            return Encoding.UCS4_BE;
        }
        if (n3 == 64 && n4 == 0 && n5 == 0 && n6 == 0) {
            return Encoding.UCS4_LE;
        }
        if (n3 == 0 && n4 == 0 && n5 == 64 && n6 == 0) {
            return Encoding.UCS4_2143;
        }
        if (n3 == 0 && n4 == 64 && n5 == 0 && n6 == 0) {
            return Encoding.UCS4_3412;
        }
        if (n3 == 0 && n4 == 64 && n5 == 0 && (n6 == 99 || n6 == 67)) {
            return Encoding.UTF16_BE;
        }
        if (n3 == 64 && n4 == 0 && (n5 == 99 || n5 == 67) && n6 == 0) {
            return Encoding.UTF16_LE;
        }
        if (!(n3 != 64 || n4 != 99 && n4 != 67 || n5 != 104 && n5 != 72 || n6 != 97 && n6 != 65)) {
            return Encoding.ASCII_COMPATIBLE;
        }
        return Encoding.UNKNOWN;
    }

    public static enum Encoding {
        UCS4_BE_BOM,
        UCS4_LE_BOM,
        UCS4_2143_BOM,
        UCS4_3412_BOM,
        UTF16_BE_BOM,
        UTF16_LE_BOM,
        UTF8_BOM,
        UCS4_BE,
        UCS4_LE,
        UCS4_2143,
        UCS4_3412,
        UTF16_BE,
        UTF16_LE,
        ASCII_COMPATIBLE,
        EBCDIC,
        UNKNOWN;

    }

    public static final class EmacsStyleDetector
    extends EncodingDetectorBase {
        private static final String[] SUFFIXES = new String[]{"-unix", "-dos", "-mac"};

        @Override
        protected String doDetectEncoding(String string) {
            int n;
            String string2 = null;
            int n2 = string.indexOf("-*-");
            if (n2 >= 0 && (n = string.indexOf("-*-", n2 += 3)) >= 0) {
                String[] stringArray;
                block0: for (String string3 : stringArray = StringUtil.split(string.substring(n2, n), ';')) {
                    if (!(string3 = string3.trim()).startsWith("coding:")) continue;
                    string2 = string3.substring(7).trim();
                    for (String string4 : SUFFIXES) {
                        if (!string2.endsWith(string4)) continue;
                        string2 = string2.substring(0, string2.length() - string4.length());
                        break block0;
                    }
                    break;
                }
            }
            return string2;
        }
    }

    public static final class HTMLCharsetDetector
    extends EncodingDetectorBase {
        private static final Pattern PATTERN = Pattern.compile("<meta.+charset\\s*=\\s*['\"]?([\\w-]+)['\"]?[^>]*>", 34);

        @Override
        protected String doDetectEncoding(String string) {
            String string2 = null;
            Matcher matcher = PATTERN.matcher(string);
            if (matcher.find()) {
                string2 = matcher.group(1).trim();
            }
            return string2;
        }
    }

    public static final class KeywordBasedDetector
    extends EncodingDetectorBase {
        public final String keyword;
        private final Pattern pattern;

        public KeywordBasedDetector(String string) {
            assert (string != null && string.trim().length() > 0);
            this.keyword = string;
            this.pattern = Pattern.compile(Pattern.quote(string) + "\\s*['\"]([^'\"]+)['\"]\\s*;");
        }

        @Override
        protected String doDetectEncoding(String string) {
            String string2 = null;
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.find()) {
                string2 = matcher.group(1).trim();
            }
            return string2;
        }
    }

    public static final class XMLEncodingDetector
    extends EncodingDetectorBase {
        private static final Pattern PATTERN = Pattern.compile("encoding\\s*=\\s*['\"]([^'\"]+)['\"]");

        @Override
        protected String doDetectEncoding(String string) {
            String string2 = null;
            if (string.startsWith("<?xml")) {
                Matcher matcher = PATTERN.matcher(string);
                if (matcher.find()) {
                    string2 = matcher.group(1).trim();
                }
                if (string2 == null || string2.length() == 0) {
                    string2 = "UTF-8";
                }
            }
            return string2;
        }
    }

    public static abstract class EncodingDetectorBase
    implements EncodingDetector {
        @Override
        public String detectEncoding(String string) {
            String string2 = this.doDetectEncoding(string);
            return LoadText.checkEncoding(string2);
        }

        protected abstract String doDetectEncoding(String var1);
    }

    public static interface EncodingDetector {
        public String detectEncoding(String var1);
    }
}

