/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import com.xmlmind.util.LinearHashtable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class IdentityLinearHashtable<K, V>
extends LinearHashtable<K, V> {
    private static final long serialVersionUID = 2856443646185780600L;

    public IdentityLinearHashtable() {
    }

    public IdentityLinearHashtable(int n) {
        super(n);
    }

    @Override
    public V get(K k) {
        int n = IdentityLinearHashtable.tableIndex(this.table, k);
        return (V)(n < 0 ? null : this.table[n + 1]);
    }

    private static int tableIndex(Object[] objectArray, Object object) {
        int n;
        assert (object != null);
        int n2 = System.identityHashCode(object);
        if (n2 < 0) {
            n2 = -n2;
        }
        int n3 = objectArray.length;
        int n4 = n = 2 * (n2 % (n3 / 2));
        do {
            Object object2;
            if ((object2 = objectArray[n4]) == null || object2 == object) {
                return n4;
            }
            if ((n4 += 2) != n3) continue;
            n4 = 0;
        } while (n4 != n);
        return -1;
    }

    @Override
    public V put(K k, V v) {
        int n = IdentityLinearHashtable.tableIndex(this.table, k);
        if (n < 0) {
            int n2 = this.table.length;
            Object[] objectArray = new Object[2 * n2];
            for (int i = 0; i < n2; i += 2) {
                Object object = this.table[i];
                if (object == null) continue;
                int n3 = IdentityLinearHashtable.tableIndex(objectArray, object);
                objectArray[n3] = object;
                objectArray[n3 + 1] = this.table[i + 1];
            }
            this.table = objectArray;
            n = IdentityLinearHashtable.tableIndex(this.table, k);
        }
        Object object = this.table[n + 1];
        this.table[n] = k;
        this.table[n + 1] = v;
        return (V)object;
    }

    @Override
    public V remove(K k) {
        int n = IdentityLinearHashtable.tableIndex(this.table, k);
        if (n < 0 || this.table[n] == null) {
            return null;
        }
        Object object = this.table[n + 1];
        this.table[n] = null;
        this.table[n + 1] = null;
        int n2 = this.table.length;
        while (true) {
            if ((n += 2) == n2) {
                n = 0;
            }
            if (this.table[n] == null) break;
            Object object2 = this.table[n];
            int n3 = IdentityLinearHashtable.tableIndex(this.table, object2);
            if (this.table[n3] != null) continue;
            this.table[n3] = object2;
            this.table[n3 + 1] = this.table[n + 1];
            this.table[n] = null;
            this.table[n + 1] = null;
        }
        return (V)object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.table.length;
        objectOutputStream.writeInt(n);
        objectOutputStream.writeInt(2 * this.size());
        for (int i = 0; i < n; i += 2) {
            if (this.table[i] == null) continue;
            objectOutputStream.writeObject(this.table[i]);
            objectOutputStream.writeObject(this.table[i + 1]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.table = new Object[objectInputStream.readInt()];
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; i += 2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            int n2 = IdentityLinearHashtable.tableIndex(this.table, object);
            this.table[n2] = object;
            this.table[n2 + 1] = object2;
        }
    }
}

