/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.netutil;

import com.xmlmind.netutil.PasswordUtil;
import com.xmlmind.util.Preferences;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Properties;

public final class ProxyUtil {
    private ProxyUtil() {
    }

    public static String getProxySettings(Preferences preferences) {
        if (preferences == null) {
            return "system";
        }
        return preferences.getString("proxySettings", "system");
    }

    public static Properties configureProxies(File file) {
        Properties properties = null;
        Preferences preferences = null;
        if (file != null) {
            preferences = new Preferences();
            if (!preferences.load(file)) {
                preferences = null;
            } else {
                properties = preferences.properties;
            }
        }
        ProxyUtil.configureProxies(preferences);
        return properties;
    }

    public static void configureProxies(Preferences preferences) {
        String string;
        String string2;
        if (preferences == null) {
            System.setProperty("java.net.useSystemProxies", "true");
            return;
        }
        String string3 = ProxyUtil.getProxySettings(preferences);
        if ("system".equals(string3)) {
            System.setProperty("java.net.useSystemProxies", "true");
        } else {
            System.setProperty("java.net.useSystemProxies", "false");
            if ("application".equals(string3)) {
                int n;
                string2 = null;
                string = preferences.getString("httpProxyHost", "");
                if (string.length() > 0) {
                    System.setProperty("http.proxyHost", string);
                    n = preferences.getInt("httpProxyPort", 1, 65535, 80);
                    System.setProperty("http.proxyPort", Integer.toString(n));
                    if (string2 == null) {
                        string2 = ProxyUtil.getNonProxyHosts(preferences);
                    }
                    if (string2.length() > 0) {
                        System.setProperty("http.nonProxyHosts", string2);
                    }
                }
                if ((string = preferences.getString("httpsProxyHost", "")).length() > 0) {
                    System.setProperty("https.proxyHost", string);
                    n = preferences.getInt("httpsProxyPort", 1, 65535, 443);
                    System.setProperty("https.proxyPort", Integer.toString(n));
                    if (string2 == null) {
                        string2 = ProxyUtil.getNonProxyHosts(preferences);
                    }
                    if (string2.length() > 0) {
                        System.setProperty("http.nonProxyHosts", string2);
                    }
                }
                if ((string = preferences.getString("ftpProxyHost", "")).length() > 0) {
                    System.setProperty("ftp.proxyHost", string);
                    n = preferences.getInt("ftpProxyPort", 1, 65535, 80);
                    System.setProperty("ftp.proxyPort", Integer.toString(n));
                    if (string2 == null) {
                        string2 = ProxyUtil.getNonProxyHosts(preferences);
                    }
                    if (string2.length() > 0) {
                        System.setProperty("ftp.nonProxyHosts", string2);
                    }
                }
                if ((string = preferences.getString("socksProxyHost", "")).length() > 0) {
                    System.setProperty("socksProxyHost", string);
                    n = preferences.getInt("socksProxyPort", 1, 65535, 1080);
                    System.setProperty("socksProxyPort", Integer.toString(n));
                }
            }
        }
        if (preferences.getBoolean("socksProxyAuthentication", false) && (string2 = preferences.getString("socksUser", "")).length() > 0) {
            string = preferences.getString("socksPassword", "");
            if (string.length() > 0) {
                string = PasswordUtil.unescapePassword(string);
            }
            if (string != null) {
                System.setProperty("java.net.socks.username", string2);
                System.setProperty("java.net.socks.password", string);
            }
        }
    }

    private static String getNonProxyHosts(Preferences preferences) {
        String[] stringArray = preferences.getStrings("nonProxyHosts", null);
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (i > 0) {
                stringBuilder.append('|');
            }
            if (string.startsWith(".")) {
                stringBuilder.append('*');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static ProxyServer queryProxySelector(String string, String string2, int n) {
        SocketAddress socketAddress;
        URI uRI;
        try {
            uRI = new URI(string, null, string2, n, "/", null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        ProxyServer proxyServer = null;
        ProxySelector proxySelector = ProxySelector.getDefault();
        List<Proxy> list = proxySelector.select(uRI);
        Proxy proxy = list.get(0);
        Proxy.Type type = proxy.type();
        if (type != Proxy.Type.DIRECT && (socketAddress = proxy.address()) instanceof InetSocketAddress) {
            proxyServer = new ProxyServer(type == Proxy.Type.SOCKS, ((InetSocketAddress)socketAddress).getHostName(), ((InetSocketAddress)socketAddress).getPort());
        }
        return proxyServer;
    }

    public static final class ProxyServer {
        public final boolean isSocks;
        public final String host;
        public final int port;

        public ProxyServer(boolean bl, String string, int n) {
            this.isSocks = bl;
            this.host = string;
            this.port = n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.isSocks ? "SOCKS " : "HTTP ");
            stringBuilder.append(this.host);
            stringBuilder.append(':');
            stringBuilder.append(this.port);
            return stringBuilder.toString();
        }
    }
}

