/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.netutil;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class PasswordUtil {
    private PasswordUtil() {
    }

    public static String getAnonymousFTPPassword() {
        Object object = PasswordUtil.getUserIdentifier();
        if (((String)object).indexOf(64) < 0) {
            object = (String)object + "@";
        }
        return object;
    }

    public static String getUserIdentifier() {
        String string;
        String string2 = PasswordUtil.getUserName();
        if (string2 == null) {
            string2 = "XXE";
        }
        if ((string = PasswordUtil.getLocalHostName()) == null) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append('@');
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static String getLocalHostName() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string;
    }

    public static String escapePassword(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        PasswordUtil.escapePassword(string, stringBuilder);
        return stringBuilder.toString();
    }

    public static void escapePassword(String string, StringBuilder stringBuilder) {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toHexString(byArray[i]);
            for (int j = string2.length(); j < 2; ++j) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
        }
    }

    public static String unescapePassword(String string) {
        int n = string.length();
        if (n == 0 || n % 2 != 0) {
            return null;
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            try {
                int n3 = Integer.parseInt(string.substring(i, i + 2), 16);
                byArray[n2++] = (byte)(n3 & 0xFF);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n2 != byArray.length) {
            return null;
        }
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

