/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.netutil;

import com.xmlmind.guiutil.DialogBase;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.IconResource;
import com.xmlmind.netutil.Msg;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class AuthenticationDialog
extends DialogBase {
    private boolean allowEmptyPassword;
    private JLabel promptLabel;
    private JTextField userNameField;
    private JPasswordField passwordField;
    private JCheckBox saveToggle;
    private Info result = null;

    public AuthenticationDialog(Component component) {
        this(component, false);
    }

    public AuthenticationDialog(Component component, boolean bl) {
        super(component, Msg.msg("auth.title"), true);
        this.allowEmptyPassword = bl;
        this.initialize(component, 26);
    }

    @Override
    protected Component createForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        JLabel jLabel = new JLabel(new IconResource(AuthenticationDialog.class, "password.png"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        jPanel.add((Component)jLabel, DialogUtil.px(gridBagConstraints));
        jLabel = new JLabel(Msg.msg("auth.prompt1"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)jLabel, DialogUtil.px(gridBagConstraints));
        this.promptLabel = new JLabel("<identifies the authentication realm>");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)this.promptLabel, DialogUtil.px(gridBagConstraints));
        String string = Msg.msg("auth.userName");
        jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 15;
        jPanel.add((Component)jLabel, DialogUtil.px(gridBagConstraints));
        this.userNameField = new JTextField(20);
        this.userNameField.setActionCommand("ok");
        this.userNameField.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.userNameField, DialogUtil.px(gridBagConstraints));
        jLabel.setLabelFor(this.userNameField);
        string = Msg.msg("auth.password");
        jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 5;
        jPanel.add((Component)jLabel, DialogUtil.px(gridBagConstraints));
        this.passwordField = new JPasswordField(20);
        this.passwordField.setActionCommand("ok");
        this.passwordField.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.passwordField, DialogUtil.px(gridBagConstraints));
        jLabel.setLabelFor(this.passwordField);
        string = Msg.msg("auth.rememberUserInfo");
        this.saveToggle = new JCheckBox(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.saveToggle, string);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.saveToggle, DialogUtil.px(gridBagConstraints));
        return jPanel;
    }

    public Info getPassword(Info info) {
        this.promptLabel.setText(info.prompt == null ? "" : Msg.msg("auth.prompt2", info.prompt));
        this.userNameField.setText(info.userName == null ? "" : info.userName);
        this.passwordField.setText(info.password == null ? "" : new String(info.password));
        this.saveToggle.setSelected(info.save);
        this.getRootPane().setDefaultButton(this.dialogButtons[0]);
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        this.userNameField.requestFocus();
        this.setVisible(true);
        return this.result;
    }

    @Override
    public void ok() {
        Info info = new Info();
        info.userName = this.userNameField.getText().trim();
        if (info.userName.length() == 0) {
            DialogUtil.badField(this.userNameField);
            return;
        }
        info.password = this.passwordField.getPassword();
        if (info.password == null || info.password.length == 0) {
            if (!this.allowEmptyPassword) {
                DialogUtil.badField(this.passwordField);
                return;
            }
            info.password = new char[0];
        }
        info.save = this.saveToggle.isSelected();
        this.result = info;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void cancel() {
        this.result = null;
        this.setVisible(false);
        this.dispose();
    }

    public static final class Info {
        public String prompt;
        public String userName;
        public char[] password;
        public boolean save;
    }
}

