/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.jhelp;

import com.xmlmind.util.ObjectUtil;
import com.xmlmind.util.URIComponent;
import java.net.URI;

final class HelpEntry
implements Comparable<HelpEntry> {
    public final String title;
    public final URI uri;
    public final boolean isMainHelpEntry;
    public final String parentLocation;
    public static final HelpEntry[] EMPTY_LIST = new HelpEntry[0];

    public HelpEntry(String string, URI uRI, boolean bl) {
        assert (string != null);
        this.title = string;
        this.uri = uRI;
        this.isMainHelpEntry = bl;
        if (uRI != null) {
            String string2 = uRI.normalize().toASCIIString();
            if (!string2.endsWith("/")) {
                string2 = URIComponent.getRawParentPath(string2);
            }
            this.parentLocation = string2;
        } else {
            this.parentLocation = null;
        }
    }

    public int hashCode() {
        int n = this.title.hashCode();
        if (this.uri != null) {
            n ^= this.uri.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof HelpEntry)) {
            return false;
        }
        HelpEntry helpEntry = (HelpEntry)object;
        return this.title.equals(helpEntry.title) && ObjectUtil.equals(this.uri, helpEntry.uri);
    }

    public String toString() {
        return this.title;
    }

    @Override
    public int compareTo(HelpEntry helpEntry) {
        if (this.isMainHelpEntry == helpEntry.isMainHelpEntry) {
            return this.title.compareTo(helpEntry.title);
        }
        if (this.isMainHelpEntry) {
            return -1;
        }
        return 1;
    }
}

