/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.jhelp;

import com.xmlmind.guiutil.Alert;
import com.xmlmind.guiutil.ShowStatus;
import com.xmlmind.jhelp.DefaultViewer;
import com.xmlmind.jhelp.Msg;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.SystemUtil;
import com.xmlmind.util.ThrowableUtil;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;

public final class DefaultViewerImpl
implements DefaultViewer {
    private final String viewerCommand;
    private static String defaultViewerOnUnix;

    public DefaultViewerImpl() {
        String string = null;
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            string = DefaultViewerImpl.defaultViewer();
        }
        this.viewerCommand = string;
    }

    private static String defaultViewer() {
        String string;
        switch (SystemUtil.PLATFORM) {
            case WINDOWS: {
                string = "start \"\" \"%U\"";
                break;
            }
            case MAC_OS: {
                string = "open \"%U\"";
                break;
            }
            default: {
                if (defaultViewerOnUnix == null) {
                    defaultViewerOnUnix = DefaultViewerImpl.findBrowserOnUnix();
                }
                string = defaultViewerOnUnix;
            }
        }
        return string;
    }

    private static String findBrowserOnUnix() {
        String[] stringArray = new String[]{"firefox", "firefox \"%U\"", "google-chrome", "google-chrome \"%U\"", "opera", "opera -newpage \"%U\"", "konqueror", "konqueror \"%U\""};
        int n = stringArray.length;
        for (int i = 0; i < n; i += 2) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            File file = SystemUtil.findAppInPath(string);
            if (file == null) continue;
            return string2;
        }
        return "firefox \"%U\"";
    }

    @Override
    public void open(URI uRI, Component component) {
        String string = this.viewerCommand != null ? this.viewerCommand : "(browse) \"%U\"";
        string = StringUtil.replaceAll(string, "%U", uRI.toASCIIString());
        ShowStatus.showStatus(component, Msg.msg("executingCommand", string));
        try {
            if (this.viewerCommand != null) {
                SystemUtil.shellStart(string);
            } else {
                Desktop.getDesktop().browse(uRI);
            }
        }
        catch (Exception exception) {
            Alert.showError(component, Msg.msg("cannotExecuteCommand", string, ThrowableUtil.reason(exception)));
        }
    }
}

