/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.URIListDataFlavor;
import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.URLUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;

public final class URIListTransferable
implements Transferable {
    public final URI[] uris;
    private File[] files;
    private DataFlavor[] dataFlavors;

    public URIListTransferable(URL uRL) {
        this.uris = new URI[]{URLUtil.urlToURI(uRL)};
    }

    public URIListTransferable(URI[] uRIArray) {
        this.uris = uRIArray;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (this.dataFlavors == null) {
            this.dataFlavors = new DataFlavor[]{URIListDataFlavor.INSTANCE, DataFlavor.stringFlavor};
            int n = this.uris.length;
            this.files = new File[n];
            for (int i = 0; i < n; ++i) {
                URI uRI = this.uris[i];
                this.files[i] = null;
                try {
                    this.files[i] = uRI.getRawFragment() != null ? URLUtil.urlToFile(uRI.toURL()) : new File(uRI);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.files[i] != null) continue;
                this.files = null;
                break;
            }
            if (this.files != null) {
                this.dataFlavors = ArrayUtil.append(this.dataFlavors, DataFlavor.javaFileListFlavor);
            }
        }
        return (DataFlavor[])this.dataFlavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].match(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        this.getTransferDataFlavors();
        Object object = null;
        if (dataFlavor.equals(URIListDataFlavor.INSTANCE) || dataFlavor.equals(DataFlavor.stringFlavor)) {
            object = URIListDataFlavor.uriListToString(this.uris);
        } else if (dataFlavor.isFlavorJavaFileListType() && this.files != null) {
            ArrayList<File> arrayList = new ArrayList<File>();
            for (File file : this.files) {
                arrayList.add(file);
            }
            object = arrayList;
        }
        if (object == null) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return object;
    }
}

