/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.URLUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.List;

public final class URIListDataFlavor
extends DataFlavor {
    public static final URIListDataFlavor INSTANCE = new URIListDataFlavor();

    public URIListDataFlavor() {
        super("text/uri-list; class=java.lang.String", null);
    }

    public static String uriListToString(URI[] uRIArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = uRIArray.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            if (i > 0) {
                stringBuilder.append("\r\n");
            }
            if (((String)(object = uRIArray[i].toASCIIString())).length() > 6 && ((String)object).startsWith("file:/") && ((String)object).charAt(6) != '/') {
                object = "file:///" + ((String)object).substring(6);
            }
            stringBuilder.append((String)object);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static URI[] uriListFromString(String string) {
        String[] stringArray = StringUtil.split(string, '\n');
        URI[] uRIArray = new URI[stringArray.length];
        int n = 0;
        for (String string2 : stringArray) {
            void object;
            String string3 = string2.trim();
            if (string3.length() == 0 || string3.charAt(0) == '#') continue;
            if (string3.startsWith("file://")) {
                if (string3.regionMatches(7, "/", 0, 1)) {
                    String string4 = "file:/" + string3.substring(8);
                } else if (string3.regionMatches(7, "localhost/", 0, 10)) {
                    String string5 = "file:/" + string3.substring(17);
                }
            }
            URI uRI = null;
            URL uRL = URLUtil.urlOrFile((String)object, true, true, null);
            if (uRL != null) {
                uRI = URLUtil.urlToURI(uRL);
            }
            if (uRI == null) continue;
            uRIArray[n++] = uRI;
        }
        if (n == 0) {
            return null;
        }
        if (n != uRIArray.length) {
            uRIArray = ArrayUtil.trimToSize(uRIArray, n);
        }
        return uRIArray;
    }

    public static URI[] uriListFromFileList(List<File> list) {
        int n = list.size();
        URI[] uRIArray = new URI[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            URI uRI = FileUtil.fileToURI(list.get(i));
            if (uRI == null) continue;
            uRIArray[n2++] = uRI;
        }
        if (n2 == 0) {
            return null;
        }
        if (n2 != uRIArray.length) {
            uRIArray = ArrayUtil.trimToSize(uRIArray, n2);
        }
        return uRIArray;
    }
}

