/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.Tab;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;

public class TearOffTab
extends Tab {
    protected String label;
    protected Icon icon;
    protected boolean hideLabelUnlessSelected;
    protected boolean rotateIcon;
    protected Rectangle[] buttons;
    protected static int ICON_GAP;
    protected static int LABEL_MARGIN_WIDTH;
    protected static int LABEL_MARGIN_HEIGHT;
    protected static int TEAR_OFF_THICKNESS;

    public TearOffTab(String string, Icon icon, Component component, boolean bl) {
        this(string, icon, component, bl, false, true, 1);
    }

    public TearOffTab(String string, Icon icon, Component component, boolean bl, boolean bl2, boolean bl3) {
        this(string, icon, component, bl, bl2, bl3, 1);
    }

    protected TearOffTab(String string, Icon icon, Component component, boolean bl, boolean bl2, boolean bl3, int n) {
        super(component, bl);
        this.label = string;
        this.icon = icon;
        this.hideLabelUnlessSelected = bl2;
        this.rotateIcon = bl3;
        this.buttons = new Rectangle[n];
        for (int i = 0; i < n; ++i) {
            this.buttons[i] = new Rectangle();
        }
        if (TEAR_OFF_THICKNESS == 0) {
            ICON_GAP = AWTUtil.px(4);
            LABEL_MARGIN_WIDTH = AWTUtil.px(5);
            LABEL_MARGIN_HEIGHT = AWTUtil.px(5);
            TEAR_OFF_THICKNESS = AWTUtil.px(3);
        }
    }

    public void setHidingLabelUnlessSelected(boolean bl) {
        this.hideLabelUnlessSelected = bl;
    }

    public boolean isHidingLabelUnlessSelected() {
        return this.hideLabelUnlessSelected;
    }

    public void setRotatingIcon(boolean bl) {
        this.rotateIcon = bl;
    }

    public boolean isRotatingIcon() {
        return this.rotateIcon;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getToolTip() {
        return this.showLabel() ? null : this.label;
    }

    protected boolean showLabel() {
        if (this.icon == null || !this.hideLabelUnlessSelected) {
            return true;
        }
        return this.selected;
    }

    @Override
    public Dimension getIntrinsicSize() {
        int n;
        boolean bl;
        boolean bl2 = this.showLabel();
        FontMetrics fontMetrics = this.pane.getFontMetrics(this.getLabelFont());
        switch (this.side) {
            case RIGHT: 
            case LEFT: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        int n2 = 0;
        int n3 = 0;
        if (this.icon != null) {
            n2 = this.icon.getIconWidth();
            n3 = this.icon.getIconHeight();
            if (bl && !this.rotateIcon) {
                n = n2;
                n2 = n3;
                n3 = n;
            }
        }
        n = 2 * LABEL_MARGIN_WIDTH;
        if (this.icon != null) {
            n += n2 + ICON_GAP;
        }
        if (bl2) {
            n += this.getLabelWidth(fontMetrics);
        }
        int n4 = Math.max(this.getLabelHeight(fontMetrics), n3);
        n4 += 2 * LABEL_MARGIN_HEIGHT;
        n4 += TEAR_OFF_THICKNESS;
        if (bl) {
            int n5 = n;
            n = n4;
            n4 = n5;
        }
        return new Dimension(n, n4);
    }

    protected Font getLabelFont() {
        return this.pane.getFont();
    }

    protected int getLabelWidth(FontMetrics fontMetrics) {
        return fontMetrics.stringWidth(this.label);
    }

    protected int getLabelHeight(FontMetrics fontMetrics) {
        return fontMetrics.getAscent() + fontMetrics.getDescent();
    }

    @Override
    public void paint(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5) {
        int n;
        int n2;
        Graphics2D graphics2D;
        int n3;
        this.paintSimpleTab(graphics, color, color2, color3, color4, color5);
        if (this.selected) {
            int n4 = this.x + this.width - 1;
            n3 = this.y + this.height - 1;
            switch (this.side) {
                case RIGHT: {
                    this.paintTearOff(graphics, this.x, this.y + 3, this.x, n3 - 3, color, color2, color3, color4, color5);
                    break;
                }
                case LEFT: {
                    this.paintTearOff(graphics, n4 - TEAR_OFF_THICKNESS, this.y + 3, n4 - TEAR_OFF_THICKNESS, n3 - 3, color, color2, color3, color4, color5);
                    break;
                }
                case BOTTOM: {
                    this.paintTearOff(graphics, this.x + 3, this.y, n4 - 3, this.y, color, color2, color3, color4, color5);
                    break;
                }
                default: {
                    this.paintTearOff(graphics, this.x + 3, n3 - TEAR_OFF_THICKNESS, n4 - 3, n3 - TEAR_OFF_THICKNESS, color, color2, color3, color4, color5);
                }
            }
        }
        boolean bl = false;
        switch (this.side) {
            case RIGHT: {
                graphics2D = (Graphics2D)graphics.create();
                graphics2D.translate(this.x + this.width - 1, this.y);
                graphics2D.rotate(1.5707963267948966);
                n3 = LABEL_MARGIN_WIDTH;
                n2 = LABEL_MARGIN_HEIGHT;
                bl = !this.rotateIcon;
                break;
            }
            case LEFT: {
                graphics2D = (Graphics2D)graphics.create();
                graphics2D.translate(this.x, this.y + this.height - 1);
                graphics2D.rotate(-1.5707963267948966);
                n3 = LABEL_MARGIN_WIDTH;
                n2 = LABEL_MARGIN_HEIGHT;
                bl = !this.rotateIcon;
                break;
            }
            case BOTTOM: {
                graphics2D = (Graphics2D)graphics;
                n3 = this.x + LABEL_MARGIN_WIDTH;
                n2 = this.y + LABEL_MARGIN_HEIGHT;
                if (this.selected) {
                    n2 += TEAR_OFF_THICKNESS;
                    break;
                }
                ++n2;
                break;
            }
            default: {
                graphics2D = (Graphics2D)graphics;
                n3 = this.x + LABEL_MARGIN_WIDTH;
                n2 = this.y + LABEL_MARGIN_HEIGHT;
            }
        }
        boolean bl2 = this.showLabel();
        Font font = this.getLabelFont();
        FontMetrics fontMetrics = this.pane.getFontMetrics(font);
        int n5 = 0;
        int n6 = 0;
        if (this.icon != null) {
            n5 = this.icon.getIconWidth();
            n6 = this.icon.getIconHeight();
            if (bl) {
                n = n5;
                n5 = n6;
                n6 = n;
            }
        }
        n = this.getLabelHeight(fontMetrics);
        int n7 = n6;
        int n8 = Math.max(n, n7);
        if (this.icon != null) {
            if (bl) {
                if (this.side == Tab.Side.RIGHT) {
                    this.icon.paintIcon(this.pane, graphics, this.x + this.width - LABEL_MARGIN_HEIGHT - n6 - (n8 - n7) / 2, this.y + LABEL_MARGIN_WIDTH);
                    n3 += n5 + ICON_GAP;
                } else {
                    this.icon.paintIcon(this.pane, graphics, this.x + LABEL_MARGIN_HEIGHT + (n8 - n7) / 2, this.y + LABEL_MARGIN_WIDTH);
                }
            } else {
                this.icon.paintIcon(this.pane, graphics2D, n3, n2 + (n8 - n7) / 2);
                n3 += n5 + ICON_GAP;
            }
        }
        if (bl2) {
            this.paintLabel(graphics2D, n3, n2, n8, font, fontMetrics, color5, color);
        }
        if (graphics2D != graphics) {
            graphics2D.dispose();
        }
    }

    protected void paintLabel(Graphics graphics, int n, int n2, int n3, Font font, FontMetrics fontMetrics, Color color, Color color2) {
        int n4 = fontMetrics.getAscent();
        int n5 = n4 + fontMetrics.getDescent();
        graphics.setFont(font);
        graphics.setColor(color);
        graphics.drawString(this.label, n, n2 + (n3 - n5) / 2 + n4);
    }

    protected void paintTearOff(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, Color color4, Color color5) {
        boolean bl = true;
        if (n == n3) {
            int n5 = n + TEAR_OFF_THICKNESS - 2;
            int n6 = n4 - n2 + 1;
            int n7 = Math.min(n6, AWTUtil.px(30));
            n4 = (n2 += (n6 - n7) / 2) + n7 - 1;
            while (n2 <= n4) {
                if (bl) {
                    graphics.setColor(color2);
                    graphics.drawLine(n, n2, n5, n2);
                    graphics.setColor(color3);
                    graphics.drawLine(n + 1, n2 + 1, n5 + 1, n2 + 1);
                }
                n2 += 2;
                bl = !bl;
            }
        } else {
            int n8 = n2 + TEAR_OFF_THICKNESS - 2;
            int n9 = n3 - n + 1;
            int n10 = Math.min(n9, AWTUtil.px(30));
            n3 = (n += (n9 - n10) / 2) + n10 - 1;
            while (n <= n3) {
                if (bl) {
                    graphics.setColor(color2);
                    graphics.drawLine(n, n2, n, n8);
                    graphics.setColor(color3);
                    graphics.drawLine(n + 1, n2 + 1, n + 1, n8 + 1);
                }
                n += 2;
                bl = !bl;
            }
        }
    }

    @Override
    public Rectangle[] getButtons() {
        this.getButtons(this.buttons);
        return this.buttons;
    }

    protected void getButtons(Rectangle[] rectangleArray) {
        Rectangle rectangle = rectangleArray[0];
        switch (this.side) {
            case RIGHT: {
                rectangle.width = TEAR_OFF_THICKNESS + LABEL_MARGIN_WIDTH / 2;
                rectangle.height = this.height;
                rectangle.x = this.x;
                rectangle.y = this.y;
                break;
            }
            case LEFT: {
                rectangle.width = TEAR_OFF_THICKNESS + LABEL_MARGIN_WIDTH / 2;
                rectangle.height = this.height;
                rectangle.x = this.x + this.width - rectangle.width;
                rectangle.y = this.y;
                break;
            }
            case BOTTOM: {
                rectangle.width = this.width;
                rectangle.height = TEAR_OFF_THICKNESS + LABEL_MARGIN_HEIGHT / 2;
                rectangle.x = this.x;
                rectangle.y = this.y;
                break;
            }
            default: {
                rectangle.width = this.width;
                rectangle.height = TEAR_OFF_THICKNESS + LABEL_MARGIN_HEIGHT / 2;
                rectangle.x = this.x;
                rectangle.y = this.y + this.height - rectangle.height;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent, int n) {
        if (!this.selected && n < 0) {
            this.pane.selectTab(this);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent, int n) {
        if (this.selected && n == 0) {
            this.pane.moveTab(this, !this.atStart);
        }
    }
}

