/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.TabbedSplitPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;

public abstract class Tab {
    protected Component component;
    protected boolean atStart;
    protected boolean selected;
    protected TabbedSplitPane pane;
    protected Object userData;
    protected Side side;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean precedesSelected;
    protected static int SEPARATOR_GAP;

    protected Tab(Component component, boolean bl) {
        this.component = component;
        this.atStart = bl;
        this.selected = false;
        if (SEPARATOR_GAP <= 0) {
            SEPARATOR_GAP = AWTUtil.px(3);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public boolean isAtStart() {
        return this.atStart;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public TabbedSplitPane getPane() {
        return this.pane;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Object getUserData() {
        return this.userData;
    }

    public Color getBackground() {
        return null;
    }

    public abstract String getLabel();

    public abstract Icon getIcon();

    public abstract String getToolTip();

    public abstract Dimension getIntrinsicSize();

    public abstract void paint(Graphics var1, Color var2, Color var3, Color var4, Color var5, Color var6);

    protected void paintSimpleTab(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5) {
        int n = this.selected ? 2 : 0;
        graphics.setColor(color);
        switch (this.side) {
            case RIGHT: {
                graphics.fillRect(this.x - 2, this.y + n, this.width + 2, this.height - 1 - n);
                break;
            }
            case LEFT: {
                graphics.fillRect(this.x, this.y + n, this.width + 2, this.height - 1 - n);
                break;
            }
            case BOTTOM: {
                graphics.fillRect(this.x + n, this.y - 2, this.width - 1 - n, this.height + 2);
                break;
            }
            default: {
                graphics.fillRect(this.x + n, this.y, this.width - 1 - n, this.height + 2);
            }
        }
        int n2 = this.x;
        int n3 = this.y;
        int n4 = this.x + this.width - 1;
        int n5 = this.y + this.height - 1;
        if (this.selected) {
            graphics.setColor(color2);
            switch (this.side) {
                case RIGHT: {
                    graphics.drawLine(n2 - 1, n3, n4, n3);
                    graphics.drawLine(n4, n3, n4, n5);
                    graphics.drawLine(n4, n5, n2 - 1, n5);
                    break;
                }
                case LEFT: {
                    graphics.drawLine(n4 + 1, n3, n2, n3);
                    graphics.drawLine(n2, n3, n2, n5);
                    graphics.drawLine(n2, n5, n4 + 1, n5);
                    break;
                }
                case BOTTOM: {
                    graphics.drawLine(n2, n3 - 1, n2, n5);
                    graphics.drawLine(n2, n5, n4, n5);
                    graphics.drawLine(n4, n5, n4, n3 - 1);
                    break;
                }
                default: {
                    graphics.drawLine(n2, n5 + 1, n2, n3);
                    graphics.drawLine(n2, n3, n4, n3);
                    graphics.drawLine(n4, n3, n4, n5 + 1);
                }
            }
            ++n2;
            ++n3;
            --n4;
            --n5;
            graphics.setColor(color4);
            switch (this.side) {
                case RIGHT: {
                    graphics.drawLine(n4, n3, n4, n5);
                    graphics.drawLine(n4, n5, n2 - 2, n5);
                    break;
                }
                case LEFT: {
                    graphics.drawLine(n2, n5, n4 + 2, n5);
                    break;
                }
                case BOTTOM: {
                    graphics.drawLine(n2, n5, n4, n5);
                    graphics.drawLine(n4, n5, n4, n3 - 2);
                    break;
                }
                default: {
                    graphics.drawLine(n4, n3, n4, n5 + 2);
                }
            }
            graphics.setColor(color3);
            switch (this.side) {
                case RIGHT: {
                    graphics.drawLine(n2 - 2, n3, n4, n3);
                    break;
                }
                case LEFT: {
                    graphics.drawLine(n4 + 2, n3, n2, n3);
                    graphics.drawLine(n2, n3, n2, n5);
                    break;
                }
                case BOTTOM: {
                    graphics.drawLine(n2, n3 - 2, n2, n5);
                    break;
                }
                default: {
                    graphics.drawLine(n2, n5 + 2, n2, n3);
                    graphics.drawLine(n2, n3, n4, n3);
                    break;
                }
            }
        } else if (!this.precedesSelected) {
            switch (this.side) {
                case RIGHT: 
                case LEFT: {
                    Tab.drawSeparator(graphics, color2, color4, n2, n5, n4, n5);
                    break;
                }
                default: {
                    Tab.drawSeparator(graphics, color2, color4, n4, n3, n4, n5);
                }
            }
        }
    }

    protected static void drawSeparator(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4) {
        if (n == n3) {
            graphics.setColor(color2);
            graphics.drawLine(n - 1, n2 += SEPARATOR_GAP, n - 1, n4 -= SEPARATOR_GAP - 1);
            graphics.setColor(color);
            graphics.drawLine(n, n2, n, n4);
        } else {
            graphics.setColor(color2);
            graphics.drawLine(n += SEPARATOR_GAP, n2 - 1, n3 -= SEPARATOR_GAP - 1, n2 - 1);
            graphics.setColor(color);
            graphics.drawLine(n, n2, n3, n2);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[atStart=");
        stringBuilder.append(this.atStart);
        stringBuilder.append(",selected=");
        stringBuilder.append(this.selected);
        stringBuilder.append(",side=");
        stringBuilder.append((Object)this.side);
        stringBuilder.append(",x=");
        stringBuilder.append(this.x);
        stringBuilder.append(",y=");
        stringBuilder.append(this.y);
        stringBuilder.append(",width=");
        stringBuilder.append(this.width);
        stringBuilder.append(",height=");
        stringBuilder.append(this.height);
        stringBuilder.append(",component=");
        stringBuilder.append(this.component);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Rectangle[] getButtons() {
        return null;
    }

    public void mousePressed(MouseEvent mouseEvent, int n) {
        if (!this.selected) {
            this.pane.selectTab(this);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent, int n) {
    }

    public static enum Side {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

