/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.DialogBase;
import com.xmlmind.guiutil.SetDateTimePane;
import java.awt.Component;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SetDateTimeDialog
extends DialogBase
implements ChangeListener {
    protected SetDateTimePane editor;
    protected Calendar editable;
    protected boolean edited;
    protected boolean ok;

    public SetDateTimeDialog(Component component, String string) {
        this(component, string, Locale.getDefault());
    }

    public SetDateTimeDialog(Component component, String string, Locale locale) {
        super(component, string, true);
        this.initialize(component, locale);
    }

    protected void initialize(Component component, Locale locale) {
        this.editor = this.createDateTimePane(Calendar.getInstance(TimeZone.getDefault(), locale), locale);
        this.editor.addChangeListener(this);
        super.initialize(component, 24);
    }

    protected SetDateTimePane createDateTimePane(Calendar calendar, Locale locale) {
        return new SetDateTimePane(calendar, locale);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.edited = true;
    }

    @Override
    protected Component createForm() {
        return this.editor;
    }

    @Override
    public void ok() {
        if (this.edited) {
            Calendar calendar = this.editor.getCalendar();
            this.editable.set(1, calendar.get(1));
            this.editable.set(2, calendar.get(2));
            this.editable.set(5, calendar.get(5));
            this.editable.set(11, calendar.get(11));
            this.editable.set(12, calendar.get(12));
            this.editable.set(13, calendar.get(13));
        }
        this.ok = true;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void cancel() {
        this.ok = false;
        this.edited = false;
        this.setVisible(false);
        this.dispose();
    }

    public boolean setDateTime(Calendar calendar) {
        this.editor.setCalendar((Calendar)calendar.clone());
        this.editable = calendar;
        this.ok = false;
        this.edited = false;
        this.getRootPane().setDefaultButton(this.dialogButtons[0]);
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        this.focusForm();
        this.setVisible(true);
        return this.ok;
    }

    protected void focusForm() {
        this.editor.focusForm();
    }
}

