/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.DialogBase;
import com.xmlmind.guiutil.SetDatePane;
import java.awt.Component;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SetDateDialog
extends DialogBase
implements ChangeListener {
    protected SetDatePane editor;
    protected Calendar editable;
    protected boolean edited;
    protected boolean ok;

    public SetDateDialog(Component component, String string) {
        this(component, string, Locale.getDefault());
    }

    public SetDateDialog(Component component, String string, Locale locale) {
        super(component, string, true);
        this.initialize(component, locale);
    }

    protected void initialize(Component component, Locale locale) {
        this.editor = this.createDatePane(Calendar.getInstance(TimeZone.getDefault(), locale), locale);
        this.editor.addChangeListener(this);
        super.initialize(component, 24);
    }

    protected SetDatePane createDatePane(Calendar calendar, Locale locale) {
        return new SetDatePane(calendar, locale);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.edited = true;
    }

    @Override
    protected Component createForm() {
        return this.editor;
    }

    @Override
    public void ok() {
        if (this.edited) {
            Calendar calendar = this.editor.getCalendar();
            this.editable.set(1, calendar.get(1));
            this.editable.set(2, calendar.get(2));
            this.editable.set(5, calendar.get(5));
        }
        this.ok = true;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void cancel() {
        this.ok = false;
        this.edited = false;
        this.setVisible(false);
        this.dispose();
    }

    public boolean setDate(Calendar calendar) {
        this.editor.setCalendar((Calendar)calendar.clone());
        this.editable = calendar;
        this.ok = false;
        this.edited = false;
        this.getRootPane().setDefaultButton(this.dialogButtons[0]);
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        this.focusForm();
        this.setVisible(true);
        return this.ok;
    }

    protected void focusForm() {
        this.editor.focusForm();
    }
}

