/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.PlaceholderIcon;
import com.xmlmind.guiutil.Ribbon;
import com.xmlmind.guiutil.Separator;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.XMLText;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class RibbonFrame
extends JPanel
implements Ribbon.Frame {
    public static final String SUPPRESS_CAPTION = "SUPPRESS_CAPTION";
    private static final Dimension[] PLACEHOLDER_DIMENSION = new Dimension[4];
    private String caption;
    private int maxHeight;
    private int hgap;
    private int vgap;
    private Font captionFont;
    private int captionH;
    private int captionHPad;
    private int captionTopPad;
    private int captionBottomPad;
    private static final int SEPAR_FACTOR = 2;
    private static Font BUTTON_FONT;
    private static FontMetrics BUTTON_FONT_METRICS;
    private static int BUTTON_TEXT_MAX_WIDTH;

    public RibbonFrame() {
        this(null, 0, 0, 0);
    }

    public RibbonFrame(String string, int n, int n2, int n3) {
        this.caption = string;
        this.setLayout(new Layout());
        this.setFont(UIManager.getFont("ToolBar.font"));
        this.setHgap(n);
        this.setVgap(n2);
        this.setMaxHeight(n3);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.captionFont = AWTUtil.pxDeriveFont(font, 0, -2);
        FontMetrics fontMetrics = this.getFontMetrics(this.captionFont);
        int n = fontMetrics.charWidth('x');
        int n2 = fontMetrics.getAscent() + fontMetrics.getDescent();
        this.captionHPad = n / 2;
        this.captionTopPad = n2 / 3;
        this.captionBottomPad = AWTUtil.px(1);
        this.captionH = this.captionTopPad + n2 + this.captionBottomPad;
        this.revalidate();
        this.repaint();
    }

    public void setCaption(String string) {
        this.caption = string;
        this.revalidate();
        this.repaint();
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    public void setHgap(int n) {
        if (n < 0) {
            n = 0;
        }
        this.hgap = n;
        this.revalidate();
        this.repaint();
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setVgap(int n) {
        if (n < 0) {
            n = 0;
        }
        this.vgap = n;
        this.revalidate();
        this.repaint();
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setMaxHeight(int n) {
        if (n <= 0) {
            n = this.computeMaxHeight(3, 16);
        }
        this.maxHeight = n;
        this.revalidate();
        this.repaint();
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int computeMaxHeight(int n, int n2) {
        if (n <= 0) {
            n = 1;
        }
        Dimension dimension = RibbonFrame.getPlaceholderSize(n2);
        return n * dimension.height + (n + 1) * this.vgap;
    }

    public static Dimension getPlaceholderSize(int n) {
        int n2 = n <= 16 ? 0 : (n <= 24 ? 1 : (n <= 32 ? 2 : 3));
        if (PLACEHOLDER_DIMENSION[n2] == null) {
            int n3 = (int)Math.rint(AWTUtil.px((double)n));
            JButton jButton = new JButton("text", new PlaceholderIcon(n3, n3));
            RibbonFrame.configureButton(jButton);
            RibbonFrame.PLACEHOLDER_DIMENSION[n2] = new Dimension(jButton.getPreferredSize());
        }
        return PLACEHOLDER_DIMENSION[n2];
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.caption != null && !SUPPRESS_CAPTION.equals(this.caption)) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            AWTUtil.setTextAntialiasing(graphics2D);
            graphics2D.setColor(this.getForeground());
            graphics2D.setFont(this.captionFont);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.drawString(this.caption, (this.getWidth() - fontMetrics.stringWidth(this.caption)) / 2, this.getHeight() - this.captionH + this.captionTopPad + fontMetrics.getAscent());
            graphics2D.dispose();
        }
    }

    public void addPlaceholder() {
        this.add(RibbonFrame.createPlaceholder());
    }

    public static Component createPlaceholder() {
        return Box.createRigidArea(RibbonFrame.getPlaceholderSize(16));
    }

    public void addSeparator() {
        this.add(new Separator(false, 2 * this.hgap, true, this.maxHeight - 2 * this.vgap));
    }

    public void addColumnBreak() {
        this.add(new ColumnBreak(this.maxHeight - 2 * this.vgap));
    }

    public Container addGroup() {
        Container container = RibbonFrame.createGroup();
        this.add(container);
        return container;
    }

    public static Container createGroup() {
        return new JPanel(new GridBagLayout());
    }

    public void add(Container container, Component component) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = container.getComponentCount();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        container.add(component, gridBagConstraints);
    }

    public void addPlaceholder(Container container) {
        this.add(container, RibbonFrame.createPlaceholder());
    }

    public void addSeparator(Container container) {
        this.add(container, (Component)new Separator(false, 2 * this.hgap, true, 0));
    }

    public void addGap(Container container) {
        this.add(container, (Component)new Separator(false, 2 * this.hgap, false, 0));
    }

    public static void configureButton(AbstractButton abstractButton) {
        if (BUTTON_FONT == null) {
            BUTTON_FONT = AWTUtil.pxDeriveFont(abstractButton.getFont(), 0, -1);
            BUTTON_FONT_METRICS = abstractButton.getFontMetrics(BUTTON_FONT);
            BUTTON_TEXT_MAX_WIDTH = 20 * BUTTON_FONT_METRICS.charWidth('M');
        }
        abstractButton.setFont(BUTTON_FONT);
        RibbonFrame.doConfigureButton(abstractButton, BUTTON_FONT_METRICS, BUTTON_TEXT_MAX_WIDTH);
    }

    public static void doConfigureButton(AbstractButton abstractButton, FontMetrics fontMetrics, int n) {
        String string;
        boolean bl;
        Icon icon = abstractButton.getIcon();
        boolean bl2 = bl = icon == null || AWTUtil.vpx(icon.getIconHeight()) <= 16;
        if (bl) {
            abstractButton.setIconTextGap(AWTUtil.px(4));
            abstractButton.setVerticalTextPosition(0);
            abstractButton.setHorizontalTextPosition(11);
        } else {
            abstractButton.setIconTextGap(AWTUtil.px(4));
            abstractButton.setVerticalTextPosition(3);
            abstractButton.setHorizontalTextPosition(0);
        }
        String string2 = abstractButton.getText();
        if (string2 != null && string2.length() > 0 && !string2.startsWith("<html>") && !string2.equals(string = RibbonFrame.wordWrap(string2, fontMetrics, n))) {
            abstractButton.setText(string);
            if (bl) {
                abstractButton.setVerticalTextPosition(1);
            }
        }
        DialogUtil.setIconic(abstractButton);
        DialogUtil.setRollover(abstractButton);
    }

    private static String wordWrap(String string, FontMetrics fontMetrics, int n) {
        if (fontMetrics.stringWidth(string) <= n) {
            return string;
        }
        String[] stringArray = StringUtil.split(string);
        if (stringArray.length <= 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = fontMetrics.charWidth(' ');
        int n3 = 0;
        for (String string2 : stringArray) {
            int n4 = fontMetrics.stringWidth(string2);
            if (n3 > 0 && n3 + n2 + n4 <= n) {
                stringBuilder.append(' ');
                XMLText.escapeXML(string2, stringBuilder);
                n3 += n2 + n4;
            } else {
                n3 = 0;
            }
            if (n3 != 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("<br />\n");
            }
            stringBuilder.append(string2);
            n3 += n4;
        }
        stringBuilder.insert(0, "<html>");
        return stringBuilder.toString();
    }

    private static final class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Serializable serializable;
            RibbonFrame ribbonFrame = (RibbonFrame)container;
            int n = ribbonFrame.maxHeight;
            int n2 = ribbonFrame.hgap;
            int n3 = ribbonFrame.vgap;
            int n4 = 0;
            int n5 = n2;
            int n6 = n3;
            int n7 = 0;
            int n8 = 0;
            int n9 = ribbonFrame.getComponentCount();
            for (int i = 0; i < n9; ++i) {
                int n10;
                serializable = ribbonFrame.getComponent(i);
                if (!((Component)serializable).isVisible()) continue;
                Dimension dimension = ((Component)serializable).getPreferredSize();
                if (dimension.width < 1) {
                    dimension.width = 1;
                }
                if (dimension.height < 1) {
                    dimension.height = 1;
                }
                if (n6 + dimension.height + n3 > n && n4 > 0) {
                    n4 = 0;
                    n5 = n7;
                    n6 = n3;
                }
                ++n4;
                n6 += dimension.height + n3;
                int n11 = n10 = serializable instanceof ColumnBreak ? 0 : n2;
                if (n5 + dimension.width + n10 > n7) {
                    n7 = n5 + dimension.width + n10;
                }
                if (n6 <= n8) continue;
                n8 = n6;
            }
            String string = ribbonFrame.caption;
            if (!RibbonFrame.SUPPRESS_CAPTION.equals(string)) {
                if (string == null) {
                    string = "?";
                }
                serializable = ribbonFrame.getFontMetrics(ribbonFrame.captionFont);
                n7 = Math.max(n7, ((FontMetrics)serializable).stringWidth(string) + 2 * ribbonFrame.captionHPad);
                n8 += ribbonFrame.captionH;
            }
            return new Dimension(n7, n8);
        }

        @Override
        public void layoutContainer(Container container) {
            RibbonFrame ribbonFrame = (RibbonFrame)container;
            int n = ribbonFrame.maxHeight;
            int n2 = ribbonFrame.hgap;
            int n3 = ribbonFrame.vgap;
            int n4 = 0;
            int n5 = n2;
            int n6 = n3;
            int n7 = 0;
            int n8 = ribbonFrame.getComponentCount();
            for (int i = 0; i < n8; ++i) {
                int n9;
                Component component = ribbonFrame.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension = component.getPreferredSize();
                if (dimension.width < 1) {
                    dimension.width = 1;
                }
                if (dimension.height < 1) {
                    dimension.height = 1;
                }
                if (n6 + dimension.height + n3 > n && n4 > 0) {
                    n4 = 0;
                    n5 = n7;
                    n6 = n3;
                }
                component.setBounds(n5, n6, dimension.width, dimension.height);
                ++n4;
                n6 += dimension.height + n3;
                int n10 = n9 = component instanceof ColumnBreak ? 0 : n2;
                if (n5 + dimension.width + n9 <= n7) continue;
                n7 = n5 + dimension.width + n9;
            }
        }
    }

    private static final class ColumnBreak
    extends Separator {
        public ColumnBreak(int n) {
            super(false, 0, false, n);
        }
    }
}

