/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;

public final class Ribbon
extends JPanel
implements MouseInputListener {
    private static final Area[] NO_AREAS = new Area[0];
    private Font buttonTextFont;
    private int buttonTextH;
    private static int buttonTextHPad;
    private static int buttonTextVPad;
    private Area[] areas;
    private boolean hasButtons;
    private int ensureIsVisible;
    private static Cursor normalCursor;
    private static Cursor clickButtonCursor;
    private static int SEPARATOR_THICKNESS;
    private static int SEPARATOR_WIDTH;
    private static int SEPARATOR_VGAP;

    public Ribbon() {
        if (normalCursor == null) {
            normalCursor = Cursor.getDefaultCursor();
            clickButtonCursor = Cursor.getPredefinedCursor(12);
            SEPARATOR_THICKNESS = AWTUtil.px(1);
            SEPARATOR_WIDTH = 3 * SEPARATOR_THICKNESS;
            SEPARATOR_VGAP = AWTUtil.px(3);
        }
        this.setLayout(new Layout());
        this.setFont(UIManager.getFont("ToolBar.font"));
        this.setCursor(normalCursor);
        this.areas = NO_AREAS;
        this.hasButtons = false;
        this.ensureIsVisible = -1;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.buttonTextFont = AWTUtil.pxDeriveFont(font, 0, -2);
        FontMetrics fontMetrics = this.getFontMetrics(this.buttonTextFont);
        int n = fontMetrics.charWidth('x');
        buttonTextVPad = buttonTextHPad = n / 2;
        this.buttonTextH = 2 * buttonTextVPad + fontMetrics.getAscent() + fontMetrics.getDescent();
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        int n = insets.top + SEPARATOR_VGAP;
        int n2 = this.getHeight() - insets.bottom - SEPARATOR_VGAP - 1;
        Color color = AWTUtil.toSeparatorColor(this.getBackground());
        Color color2 = this.getForeground();
        for (Area area : this.areas) {
            if (area.buttonText != null) {
                this.paintButtonText(graphics, color2, area);
            }
            if (n2 <= n) continue;
            this.paintSeparator(graphics, color, area.x + area.width, n, n2);
        }
    }

    private void paintSeparator(Graphics graphics, Color color, int n, int n2, int n3) {
        graphics.setColor(color);
        int n4 = n + SEPARATOR_WIDTH / 2;
        int n5 = n4 + SEPARATOR_THICKNESS - 1;
        for (int i = n4; i <= n5; ++i) {
            graphics.drawLine(i, n2, i, n3);
        }
    }

    private void paintButtonText(Graphics graphics, Color color, Area area) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        AWTUtil.setTextAntialiasing(graphics2D);
        graphics2D.setColor(color);
        graphics2D.setFont(this.buttonTextFont);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.translate(area.x, area.y + area.height - 1);
        graphics2D.rotate(-1.5707963267948966);
        String string = "\u00ab " + area.buttonText;
        int n2 = fontMetrics.stringWidth(string);
        int n3 = area.height - 2 * buttonTextHPad;
        while (n2 > n3 && (n = string.length() - 2) >= 5) {
            string = string.substring(0, n) + "\u2026";
            n2 = fontMetrics.stringWidth(string);
        }
        graphics2D.drawString(string, (area.height - n2) / 2, buttonTextVPad + fontMetrics.getAscent());
        graphics2D.dispose();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.hasButtons && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = -1;
            int n4 = this.areas.length;
            for (int i = 0; i < n4; ++i) {
                Area area = this.areas[i];
                if (area.buttonText == null || n < area.x || n >= area.x + area.width || n2 < area.y || n2 >= area.y + area.height) continue;
                n3 = i;
                break;
            }
            if (n3 >= 0) {
                this.ensureIsVisible = n3;
                this.revalidate();
                this.repaint();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.hasButtons) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Cursor cursor = normalCursor;
            for (Area area : this.areas) {
                if (area.buttonText == null || n < area.x || n >= area.x + area.width || n2 < area.y || n2 >= area.y + area.height) continue;
                cursor = clickButtonCursor;
                break;
            }
            if (this.getCursor() != cursor) {
                this.setCursor(cursor);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private static final class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.layoutSize((Ribbon)container, true);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.layoutSize((Ribbon)container, false);
        }

        private Dimension layoutSize(Ribbon ribbon, boolean bl) {
            Serializable serializable;
            int n = 0;
            int n2 = 0;
            int n3 = Math.max(2 * buttonTextHPad, 4 * SEPARATOR_VGAP);
            int n4 = ribbon.getComponentCount();
            for (int i = 0; i < n4; ++i) {
                serializable = ribbon.getComponent(i);
                Dimension dimension = serializable.getPreferredSize();
                if (dimension.width < 1) {
                    dimension.width = 1;
                }
                n += dimension.width;
                if (dimension.width > n2) {
                    n2 = dimension.width;
                }
                if (dimension.height <= n3) continue;
                n3 = dimension.height;
            }
            if (bl) {
                n = n2 + (n4 - 1) * ribbon.buttonTextH;
            }
            Dimension dimension = new Dimension(n += n4 * SEPARATOR_WIDTH, n3);
            serializable = ribbon.getInsets();
            dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
            dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
            return dimension;
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            Ribbon ribbon = (Ribbon)container;
            int n2 = ribbon.getComponentCount();
            if (n2 == 0) {
                ribbon.areas = NO_AREAS;
                ribbon.hasButtons = false;
                ribbon.ensureIsVisible = -1;
                return;
            }
            ribbon.hasButtons = false;
            int n3 = 0;
            if (ribbon.ensureIsVisible >= 0) {
                if (ribbon.ensureIsVisible < n2) {
                    n3 = ribbon.ensureIsVisible;
                }
                ribbon.ensureIsVisible = -1;
            }
            if (ribbon.areas.length != n2) {
                ribbon.areas = new Area[n2];
                for (int i = 0; i < n2; ++i) {
                    ribbon.areas[i] = new Area();
                }
            }
            Component component = ribbon.getComponent(n3);
            Dimension dimension = component.getPreferredSize();
            if (dimension.width < 1) {
                dimension.width = 1;
            }
            int n4 = Math.max(2 * buttonTextHPad, 4 * SEPARATOR_VGAP);
            n4 = Math.max(n4, dimension.height);
            component.setVisible(true);
            Area area = ribbon.areas[n3];
            area.width = dimension.width;
            area.buttonText = null;
            int n5 = dimension.width + n2 * SEPARATOR_WIDTH;
            Insets insets = ribbon.getInsets();
            int n6 = ribbon.getWidth() - insets.left - insets.right;
            for (n = 0; n < n2; ++n) {
                if (n == n3) continue;
                component = ribbon.getComponent(n);
                dimension = component.getPreferredSize();
                if (dimension.width < 1) {
                    dimension.width = 1;
                }
                n4 = Math.max(n4, dimension.height);
                area = ribbon.areas[n];
                if (n5 + dimension.width <= n6) {
                    component.setVisible(true);
                    area.width = dimension.width;
                    area.buttonText = null;
                } else {
                    component.setVisible(false);
                    area.width = ribbon.buttonTextH;
                    area.buttonText = null;
                    if (component instanceof Frame) {
                        area.buttonText = ((Frame)((Object)component)).getCaption();
                    }
                    if (area.buttonText == null) {
                        area.buttonText = Integer.toString(n);
                    }
                    ribbon.hasButtons = true;
                }
                n5 += area.width;
            }
            n = insets.left;
            int n7 = insets.top;
            for (int i = 0; i < n2; ++i) {
                component = ribbon.getComponent(i);
                area = ribbon.areas[i];
                component.setBounds(n, n7, area.width, n4);
                area.x = n;
                area.y = n7;
                area.height = n4;
                n += area.width + SEPARATOR_WIDTH;
            }
        }
    }

    private static final class Area {
        public int x;
        public int y;
        public int width;
        public int height;
        public String buttonText;

        private Area() {
        }
    }

    public static interface Frame {
        public String getCaption();
    }
}

