/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.BrowseButton;
import com.xmlmind.guiutil.DialogBase;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.HintLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PromptDialog
extends DialogBase {
    protected int columns;
    protected boolean addBrowseButton;
    protected JLabel promptLabel;
    protected JTextField valueField;
    protected BrowseButton browseButton;
    protected URL baseURL;
    protected boolean allowAnyString;
    protected String result;

    public PromptDialog(Component component) {
        this(component, -1, true, false);
    }

    public PromptDialog(Component component, boolean bl, boolean bl2) {
        this(component, -1, bl, bl2);
    }

    public PromptDialog(Component component, int n, boolean bl, boolean bl2) {
        super(component, "", true);
        this.initialize(component, n, bl, bl2);
    }

    protected void initialize(Component component, int n, boolean bl, boolean bl2) {
        if (n <= 0) {
            n = 60;
        }
        this.columns = n;
        int n2 = 26;
        if (bl2) {
            n2 |= 0x40;
        }
        this.addBrowseButton = bl;
        super.initialize(component, n2);
    }

    @Override
    protected Component createForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.promptLabel = new JLabel("???");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        jPanel.add((Component)this.promptLabel, DialogUtil.px(gridBagConstraints));
        HintLabel hintLabel = this.createHint();
        this.valueField = new JTextField(this.columns);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 1;
        if (hintLabel == null) {
            gridBagConstraints.insets.bottom = 5;
        }
        if (!this.addBrowseButton) {
            gridBagConstraints.insets.right = 5;
        }
        jPanel.add((Component)this.valueField, DialogUtil.px(gridBagConstraints));
        if (this.addBrowseButton) {
            this.browseButton = new BrowseButton();
            this.browseButton.setActionCommand("browse");
            this.browseButton.addActionListener(this);
            ++gridBagConstraints.gridx;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets.left = 2;
            gridBagConstraints.insets.right = 5;
            jPanel.add((Component)this.browseButton, DialogUtil.px(gridBagConstraints));
        }
        if (hintLabel != null) {
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets.right = 5;
            gridBagConstraints.insets.bottom = 5;
            jPanel.add((Component)hintLabel, DialogUtil.px(gridBagConstraints));
        }
        return jPanel;
    }

    protected HintLabel createHint() {
        return null;
    }

    @Override
    public void ok() {
        this.result = this.checkValue(this.valueField.getText());
        if (this.result == null) {
            DialogUtil.badField(this.valueField);
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    protected String checkValue(String string) {
        if (this.allowAnyString) {
            return string;
        }
        if ((string = string.trim()).length() > 0) {
            return string;
        }
        return null;
    }

    @Override
    public void cancel() {
        this.result = null;
        this.setVisible(false);
        this.dispose();
    }

    public void browse() {
        String string = this.browseButton.getSelection(this, this.baseURL);
        if (string != null) {
            this.valueField.setText(string);
        }
    }

    public String getValue(String string, String string2, String string3, URL uRL, boolean bl) {
        this.baseURL = uRL;
        this.allowAnyString = bl;
        if (string != null) {
            this.setTitle(string);
        }
        this.promptLabel.setText(string2);
        this.valueField.setText(string3 == null ? "" : string3);
        this.valueField.selectAll();
        this.getRootPane().setDefaultButton(this.dialogButtons[0]);
        this.setLocationRelativeTo(this.dialogAnchor);
        this.pack();
        this.valueField.requestFocus();
        this.setVisible(true);
        return this.result;
    }
}

