/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.ThreadMonitorDialog;
import com.xmlmind.util.Console;
import com.xmlmind.util.Log;
import com.xmlmind.util.ProgressMonitor;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;

public final class PossiblyLengthyTaskMonitor
implements ProgressMonitor {
    public final AtomicReference<ThreadMonitorDialog> monitorDialog;
    public final String messageLog;
    private int animateMillis;
    private int stepCount;
    private int step;
    private ArrayList<Object> messages;
    private ThreadMonitorDialog threadMonitorDialog;

    public PossiblyLengthyTaskMonitor(AtomicReference<ThreadMonitorDialog> atomicReference, String string) {
        this.monitorDialog = atomicReference;
        this.messageLog = string;
        this.messages = new ArrayList();
    }

    public void setAnimateMillis(int n) {
        this.animateMillis = n;
    }

    public int getAnimateMillis() {
        return this.animateMillis;
    }

    @Override
    public void start() {
    }

    @Override
    public boolean stepCount(int n) {
        this.stepCount = n;
        boolean bl = false;
        boolean bl2 = this.threadMonitorDialog == null;
        ThreadMonitorDialog threadMonitorDialog = this.getThreadMonitorDialog();
        if (threadMonitorDialog != null) {
            if (bl2) {
                this.addBufferedMessages(threadMonitorDialog);
            }
            bl = threadMonitorDialog.isCanceled();
        }
        return !bl;
    }

    private ThreadMonitorDialog getThreadMonitorDialog() {
        if (this.threadMonitorDialog == null) {
            this.threadMonitorDialog = this.monitorDialog.get();
        }
        return this.threadMonitorDialog;
    }

    private void addBufferedMessages(ThreadMonitorDialog threadMonitorDialog) {
        int n = this.messages.size();
        if (n > 0) {
            threadMonitorDialog.setMessage((String)this.messages.get(0), ThreadMonitorDialog.toLogLevel((Console.MessageType)((Object)this.messages.get(1))));
            for (int i = 2; i < n; i += 2) {
                threadMonitorDialog.appendMessage((String)this.messages.get(i), ThreadMonitorDialog.toLogLevel((Console.MessageType)((Object)this.messages.get(i + 1))));
            }
        }
    }

    @Override
    public boolean step(int n) {
        this.step = n;
        boolean bl = false;
        boolean bl2 = this.threadMonitorDialog == null;
        ThreadMonitorDialog threadMonitorDialog = this.getThreadMonitorDialog();
        if (threadMonitorDialog != null) {
            if (this.stepCount > 0) {
                threadMonitorDialog.setProgress(n, this.stepCount);
            }
            if (bl2) {
                this.addBufferedMessages(threadMonitorDialog);
            }
            bl = threadMonitorDialog.isCanceled();
        }
        if (this.animateMillis > 0) {
            try {
                Thread.sleep(this.animateMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return !bl;
    }

    @Override
    public boolean message(String string, Console.MessageType messageType) {
        this.messages.add(string);
        this.messages.add((Object)messageType);
        Log.Level level = ThreadMonitorDialog.toLogLevel(messageType);
        if (this.messageLog != null) {
            Log.getLog(this.messageLog).log(level, string);
        }
        boolean bl = false;
        boolean bl2 = this.threadMonitorDialog == null;
        ThreadMonitorDialog threadMonitorDialog = this.getThreadMonitorDialog();
        if (threadMonitorDialog != null) {
            if (bl2) {
                this.addBufferedMessages(threadMonitorDialog);
            } else {
                threadMonitorDialog.appendMessage(string, level);
            }
            bl = threadMonitorDialog.isCanceled();
        }
        if (this.animateMillis > 0) {
            try {
                Thread.sleep(this.animateMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return !bl;
    }

    @Override
    public void stop() {
    }
}

