/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.PaneResizedEvent;
import com.xmlmind.guiutil.PaneResizedListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public class MultiSplitPane
extends JPanel {
    protected boolean collapsible;
    protected int separatorSize;
    protected boolean separatorRelief;
    protected boolean separatorHandle;
    protected Constraints[] constraints;
    protected int availableWidth;
    protected int availableHeight;
    protected Rectangle topSeparator;
    protected Rectangle rightSeparator;
    protected Rectangle bottomSeparator;
    protected Rectangle leftSeparator;
    protected boolean hasSeparators;
    protected EventListenerList paneResizedListeners;
    protected static Cursor normalCursor;
    protected static Cursor verticalResizeCursor;
    protected static Cursor horizontalResizeCursor;
    protected static Cursor clickButtonCursor;
    protected static int SEPARATOR_MIN_SIZE;
    protected static int HANDLE_SIZE;
    protected static int ICON_WIDTH;
    protected static int ICON_HEIGHT;
    protected static final int STRICT_MINIMUM = 0;
    protected static final int MINIMUM = 1;
    protected static final int PREFERRED = 2;

    public MultiSplitPane() {
        if (normalCursor == null) {
            normalCursor = Cursor.getDefaultCursor();
            verticalResizeCursor = Cursor.getPredefinedCursor(11);
            horizontalResizeCursor = Cursor.getPredefinedCursor(8);
            clickButtonCursor = Cursor.getPredefinedCursor(12);
            SEPARATOR_MIN_SIZE = AWTUtil.px(5);
            HANDLE_SIZE = AWTUtil.px(3);
            ICON_WIDTH = AWTUtil.px(7);
            ICON_WIDTH = ICON_WIDTH / 2 * 2 + 1;
            ICON_HEIGHT = (ICON_WIDTH + 1) / 2;
        }
        this.separatorSize = SEPARATOR_MIN_SIZE;
        this.separatorRelief = false;
        this.separatorHandle = false;
        this.constraints = new Constraints[0];
        this.topSeparator = new Rectangle();
        this.rightSeparator = new Rectangle();
        this.bottomSeparator = new Rectangle();
        this.leftSeparator = new Rectangle();
        this.setLayout(new Layout());
        this.setCursor(normalCursor);
        this.paneResizedListeners = new EventListenerList();
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    public void setCollapsible(boolean bl) {
        if (bl != this.collapsible) {
            this.collapsible = bl;
            if (!bl) {
                for (Constraints constraints : this.constraints) {
                    constraints.collapsed = false;
                }
            }
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isCollapsible() {
        return this.collapsible;
    }

    public void setSeparatorSize(int n) {
        if (n < SEPARATOR_MIN_SIZE) {
            n = SEPARATOR_MIN_SIZE;
        }
        if (n != this.separatorSize) {
            this.separatorSize = n;
            this.revalidate();
            this.repaint();
        }
    }

    public int getSeparatorSize() {
        return this.separatorSize;
    }

    public void setSeparatorRelief(boolean bl) {
        if (bl != this.separatorRelief) {
            this.separatorRelief = bl;
            this.repaint();
        }
    }

    public boolean getSeparatorRelief() {
        return this.separatorRelief;
    }

    public void setSeparatorHandle(boolean bl) {
        if (bl != this.separatorHandle) {
            this.separatorHandle = bl;
            int n = SEPARATOR_MIN_SIZE;
            if (bl) {
                n += HANDLE_SIZE;
            }
            this.setSeparatorSize(n);
            this.repaint();
        }
    }

    public boolean getSeparatorHandle() {
        return this.separatorHandle;
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        int n2;
        if (n < 0) {
            n = this.getComponentCount();
        }
        if (n >= 5) {
            throw new IllegalArgumentException(Integer.toString(n) + ", bad index: a MultiSplitPane can contain at most 5 components");
        }
        Constraints constraints = (Constraints)object;
        constraints = constraints == null ? new Constraints() : constraints.copy();
        for (int i = 0; i < this.constraints.length; ++i) {
            if (constraints.position != this.constraints[i].position) continue;
            throw new IllegalArgumentException("there is already a Component at " + String.valueOf((Object)constraints.position));
        }
        Constraints[] constraintsArray = new Constraints[this.constraints.length + 1];
        if (n > 0) {
            System.arraycopy(this.constraints, 0, constraintsArray, 0, n);
        }
        if ((n2 = this.constraints.length - n) > 0) {
            System.arraycopy(this.constraints, n, constraintsArray, n + 1, n2);
        }
        constraintsArray[n] = constraints;
        this.constraints = constraintsArray;
        super.addImpl(component, object, n);
    }

    @Override
    public void remove(int n) {
        int n2;
        int n3;
        Constraints[] constraintsArray = new Constraints[this.constraints.length - 1];
        if (n > 0) {
            System.arraycopy(this.constraints, 0, constraintsArray, 0, n);
        }
        if ((n3 = this.constraints.length - (n2 = n + 1)) > 0) {
            System.arraycopy(this.constraints, n2, constraintsArray, n, n3);
        }
        this.constraints = constraintsArray;
        super.remove(n);
    }

    @Override
    public void removeAll() {
        if (this.getComponentCount() > 0) {
            this.constraints = new Constraints[0];
            super.removeAll();
        }
    }

    public boolean isCollapsed(Component component) {
        Constraints constraints = this.getConstraints(component);
        return constraints == null || constraints.position == Position.CENTER ? false : constraints.collapsed;
    }

    public void setCollapsed(Component component, boolean bl) {
        Constraints constraints = this.getConstraints(component);
        if (constraints != null && constraints.position != Position.CENTER && constraints.collapsed != bl) {
            constraints.collapsed = bl;
            this.revalidate();
            this.repaint();
        }
    }

    public Constraints getConstraints(Component component) {
        int n = this.indexOfComponent(component);
        if (n < 0) {
            return null;
        }
        return this.getConstraints(n);
    }

    public int indexOfComponent(Component component) {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (this.getComponent(i) != component) continue;
            return i;
        }
        return -1;
    }

    public Constraints getConstraints(int n) {
        return this.constraints[n];
    }

    public int indexOfPosition(Position position) {
        for (int i = 0; i < this.constraints.length; ++i) {
            if (this.constraints[i].position != position) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.hasSeparators) {
            this.paintSeparators(graphics);
        }
    }

    protected void paintSeparators(Graphics graphics) {
        Constraints constraints;
        if (this.topSeparator.width > 0) {
            constraints = this.constraints[this.indexOfPosition(Position.TOP)];
            this.paintSeparator(graphics, this.topSeparator, Position.TOP, constraints.collapsed, constraints.collapsed ? Position.BOTTOM : Position.TOP);
        }
        if (this.bottomSeparator.width > 0) {
            constraints = this.constraints[this.indexOfPosition(Position.BOTTOM)];
            this.paintSeparator(graphics, this.bottomSeparator, Position.BOTTOM, constraints.collapsed, constraints.collapsed ? Position.TOP : Position.BOTTOM);
        }
        if (this.leftSeparator.width > 0) {
            constraints = this.constraints[this.indexOfPosition(Position.LEFT)];
            this.paintSeparator(graphics, this.leftSeparator, Position.LEFT, constraints.collapsed, constraints.collapsed ? Position.RIGHT : Position.LEFT);
        }
        if (this.rightSeparator.width > 0) {
            constraints = this.constraints[this.indexOfPosition(Position.RIGHT)];
            this.paintSeparator(graphics, this.rightSeparator, Position.RIGHT, constraints.collapsed, constraints.collapsed ? Position.LEFT : Position.RIGHT);
        }
    }

    protected void paintSeparator(Graphics graphics, Rectangle rectangle, Position position, boolean bl, Position position2) {
        int n;
        int n2;
        int n3;
        int n4;
        Color color = this.getBackground();
        Color color2 = AWTUtil.toBorderColor(color);
        Color color3 = AWTUtil.toHighlightColor(color);
        Color color4 = AWTUtil.toShadowColor(color);
        if (this.separatorRelief) {
            switch (position) {
                case TOP: 
                case BOTTOM: {
                    n4 = rectangle.x;
                    n3 = n4 + rectangle.width - 1;
                    n = n2 = rectangle.y;
                    if (!bl || position != Position.TOP) {
                        graphics.setColor(color2);
                        graphics.drawLine(n4, n, n3, n2);
                        graphics.setColor(color3);
                        graphics.drawLine(n4, n + 1, n3, n2 + 1);
                    }
                    n = n2 = n + rectangle.height - 1;
                    if (bl && position == Position.BOTTOM) break;
                    graphics.setColor(color4);
                    graphics.drawLine(n4, n - 1, n3, n2 - 1);
                    graphics.setColor(color2);
                    graphics.drawLine(n4, n, n3, n2);
                    break;
                }
                default: {
                    n4 = n3 = rectangle.x;
                    n = rectangle.y;
                    n2 = n + rectangle.height - 1;
                    if (!bl || position != Position.LEFT) {
                        graphics.setColor(color2);
                        graphics.drawLine(n4, n, n3, n2);
                        graphics.setColor(color3);
                        graphics.drawLine(n4 + 1, n, n3 + 1, n2);
                    }
                    n4 = n3 = n4 + rectangle.width - 1;
                    if (bl && position == Position.RIGHT) break;
                    graphics.setColor(color4);
                    graphics.drawLine(n4 - 1, n, n3 - 1, n2);
                    graphics.setColor(color2);
                    graphics.drawLine(n4, n, n3, n2);
                }
            }
        }
        if (this.separatorHandle) {
            switch (position) {
                case TOP: 
                case BOTTOM: {
                    n4 = rectangle.x;
                    n3 = n4 + rectangle.width - 1;
                    n = rectangle.y + (rectangle.height - HANDLE_SIZE) / 2;
                    n2 = n + HANDLE_SIZE - 1;
                    int n5 = n3 - n4 + 1;
                    int n6 = Math.min(n5, AWTUtil.px(30));
                    n3 = (n4 += (n5 - n6) / 2) + n6 - 1;
                    boolean bl2 = true;
                    while (n4 <= n3) {
                        if (bl2) {
                            graphics.setColor(color2);
                            graphics.drawLine(n4, n, n4, n2);
                            graphics.setColor(color3);
                            graphics.drawLine(n4 + 1, n + 1, n4 + 1, n2 + 1);
                        }
                        n4 += 2;
                        bl2 = !bl2;
                    }
                    break;
                }
                default: {
                    n4 = rectangle.x + (rectangle.width - HANDLE_SIZE) / 2;
                    n3 = n4 + HANDLE_SIZE - 1;
                    n = rectangle.y;
                    n2 = n + rectangle.height - 1;
                    int n7 = n2 - n + 1;
                    int n8 = Math.min(n7, AWTUtil.px(30));
                    n2 = (n += (n7 - n8) / 2) + n8 - 1;
                    boolean bl3 = true;
                    while (n <= n2) {
                        if (bl3) {
                            graphics.setColor(color2);
                            graphics.drawLine(n4, n, n3, n);
                            graphics.setColor(color3);
                            graphics.drawLine(n4 + 1, n + 1, n3 + 1, n + 1);
                        }
                        n += 2;
                        bl3 = !bl3;
                    }
                    break block3;
                }
            }
        }
        if (this.collapsible) {
            graphics.setColor(this.getForeground());
            MultiSplitPane.paintCollapseIcon(graphics, rectangle, position2);
        }
    }

    protected static final void paintCollapseIcon(Graphics graphics, Rectangle rectangle, Position position) {
        int n;
        int n2;
        int n3;
        int n4;
        switch (position) {
            case TOP: {
                n4 = rectangle.x + ICON_WIDTH;
                n3 = rectangle.y + (rectangle.height - ICON_HEIGHT) / 2;
                n2 = ICON_WIDTH;
                n = ICON_HEIGHT;
                break;
            }
            case BOTTOM: {
                n4 = rectangle.x + ICON_WIDTH;
                n3 = rectangle.y + (rectangle.height - ICON_HEIGHT) / 2;
                n2 = ICON_WIDTH;
                n = ICON_HEIGHT;
                break;
            }
            case LEFT: {
                n4 = rectangle.x + (rectangle.width - ICON_HEIGHT) / 2;
                n3 = rectangle.y + ICON_WIDTH;
                n2 = ICON_HEIGHT;
                n = ICON_WIDTH;
                break;
            }
            default: {
                n4 = rectangle.x + (rectangle.width - ICON_HEIGHT) / 2;
                n3 = rectangle.y + ICON_WIDTH;
                n2 = ICON_HEIGHT;
                n = ICON_WIDTH;
            }
        }
        MultiSplitPane.drawTriangle(graphics, n4, n3, n2, n, position);
    }

    protected static final void drawTriangle(Graphics graphics, int n, int n2, int n3, int n4, Position position) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        switch (position) {
            case TOP: {
                nArray[0] = n + n3 / 2;
                nArray2[0] = n2;
                nArray[1] = n + n3 - 1;
                nArray2[1] = n2 + n4 - 1;
                nArray[2] = n;
                nArray2[2] = nArray2[1];
                break;
            }
            case BOTTOM: {
                nArray[0] = n;
                nArray2[0] = n2;
                nArray[1] = n + n3 - 1;
                nArray2[1] = n2;
                nArray[2] = n + n3 / 2;
                nArray2[2] = n2 + n4 - 1;
                break;
            }
            case LEFT: {
                nArray[0] = n + n3 - 1;
                nArray2[0] = n2;
                nArray[1] = nArray[0];
                nArray2[1] = n2 + n4 - 1;
                nArray[2] = n;
                nArray2[2] = n2 + n4 / 2;
                break;
            }
            default: {
                nArray[0] = n;
                nArray2[0] = n2;
                nArray[1] = n;
                nArray2[1] = n2 + n4 - 1;
                nArray[2] = n + n3 - 1;
                nArray2[2] = n2 + n4 / 2;
            }
        }
        graphics.fillPolygon(nArray, nArray2, 3);
        graphics.drawPolygon(nArray, nArray2, 3);
    }

    public void addPaneResizedListener(PaneResizedListener paneResizedListener) {
        this.paneResizedListeners.add(PaneResizedListener.class, paneResizedListener);
    }

    public void removePaneResizedListener(PaneResizedListener paneResizedListener) {
        this.paneResizedListeners.remove(PaneResizedListener.class, paneResizedListener);
    }

    private void firePaneResized(Component component, Constraints constraints) {
        Object[] objectArray = this.paneResizedListeners.getListenerList();
        if (objectArray.length == 0) {
            return;
        }
        PaneResizedEvent paneResizedEvent = new PaneResizedEvent(this, component, constraints);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PaneResizedListener.class) continue;
            ((PaneResizedListener)objectArray[i + 1]).paneResized(paneResizedEvent);
        }
    }

    protected final class MouseHandler
    extends MouseInputAdapter {
        private boolean dragging;
        private Component resizedComponent;
        private Constraints resizedConstraints;
        private int dragX = -1;
        private int dragY = -1;
        private Position clickedPosition;
        private boolean[] buttonClicked = new boolean[1];

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (MultiSplitPane.this.hasSeparators) {
                this.updateCursor(mouseEvent);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (MultiSplitPane.this.hasSeparators && MultiSplitPane.this.getCursor() != normalCursor) {
                MultiSplitPane.this.setCursor(normalCursor);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (MultiSplitPane.this.hasSeparators) {
                this.updateCursor(mouseEvent);
            }
        }

        private void updateCursor(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Cursor cursor = MultiSplitPane.this.topSeparator.width > 0 && n >= MultiSplitPane.this.topSeparator.x && n < MultiSplitPane.this.topSeparator.x + MultiSplitPane.this.topSeparator.width && n2 >= MultiSplitPane.this.topSeparator.y && n2 < MultiSplitPane.this.topSeparator.y + MultiSplitPane.this.topSeparator.height ? (MultiSplitPane.this.collapsible && n < MultiSplitPane.this.topSeparator.x + 3 * ICON_WIDTH ? clickButtonCursor : horizontalResizeCursor) : (MultiSplitPane.this.rightSeparator.width > 0 && n >= MultiSplitPane.this.rightSeparator.x && n < MultiSplitPane.this.rightSeparator.x + MultiSplitPane.this.rightSeparator.width && n2 >= MultiSplitPane.this.rightSeparator.y && n2 < MultiSplitPane.this.rightSeparator.y + MultiSplitPane.this.rightSeparator.height ? (MultiSplitPane.this.collapsible && n2 < MultiSplitPane.this.rightSeparator.y + 3 * ICON_WIDTH ? clickButtonCursor : verticalResizeCursor) : (MultiSplitPane.this.bottomSeparator.width > 0 && n >= MultiSplitPane.this.bottomSeparator.x && n < MultiSplitPane.this.bottomSeparator.x + MultiSplitPane.this.bottomSeparator.width && n2 >= MultiSplitPane.this.bottomSeparator.y && n2 < MultiSplitPane.this.bottomSeparator.y + MultiSplitPane.this.bottomSeparator.height ? (MultiSplitPane.this.collapsible && n < MultiSplitPane.this.bottomSeparator.x + 3 * ICON_WIDTH ? clickButtonCursor : horizontalResizeCursor) : (MultiSplitPane.this.leftSeparator.width > 0 && n >= MultiSplitPane.this.leftSeparator.x && n < MultiSplitPane.this.leftSeparator.x + MultiSplitPane.this.leftSeparator.width && n2 >= MultiSplitPane.this.leftSeparator.y && n2 < MultiSplitPane.this.leftSeparator.y + MultiSplitPane.this.leftSeparator.height ? (MultiSplitPane.this.collapsible && n2 < MultiSplitPane.this.leftSeparator.y + 3 * ICON_WIDTH ? clickButtonCursor : verticalResizeCursor) : normalCursor)));
            if (MultiSplitPane.this.getCursor() != cursor) {
                MultiSplitPane.this.setCursor(cursor);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            int n2;
            Position position;
            if (MultiSplitPane.this.hasSeparators && (position = this.whichPosition(n2 = mouseEvent.getX(), n = mouseEvent.getY(), this.buttonClicked)) != null) {
                if (this.buttonClicked[0]) {
                    this.startClick(position);
                } else {
                    this.startDrag(position, n2, n);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.dragging) {
                this.doDrag(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.dragging) {
                this.endDrag(mouseEvent);
            } else {
                this.endClick(mouseEvent);
            }
        }

        private Position whichPosition(int n, int n2, boolean[] blArray) {
            Position position = null;
            blArray[0] = false;
            if (MultiSplitPane.this.topSeparator.width > 0 && n >= MultiSplitPane.this.topSeparator.x && n < MultiSplitPane.this.topSeparator.x + MultiSplitPane.this.topSeparator.width && n2 >= MultiSplitPane.this.topSeparator.y && n2 < MultiSplitPane.this.topSeparator.y + MultiSplitPane.this.topSeparator.height) {
                position = Position.TOP;
                if (MultiSplitPane.this.collapsible && n < MultiSplitPane.this.topSeparator.x + 3 * ICON_WIDTH) {
                    blArray[0] = true;
                }
            } else if (MultiSplitPane.this.rightSeparator.width > 0 && n >= MultiSplitPane.this.rightSeparator.x && n < MultiSplitPane.this.rightSeparator.x + MultiSplitPane.this.rightSeparator.width && n2 >= MultiSplitPane.this.rightSeparator.y && n2 < MultiSplitPane.this.rightSeparator.y + MultiSplitPane.this.rightSeparator.height) {
                position = Position.RIGHT;
                if (MultiSplitPane.this.collapsible && n2 < MultiSplitPane.this.rightSeparator.y + 3 * ICON_WIDTH) {
                    blArray[0] = true;
                }
            } else if (MultiSplitPane.this.bottomSeparator.width > 0 && n >= MultiSplitPane.this.bottomSeparator.x && n < MultiSplitPane.this.bottomSeparator.x + MultiSplitPane.this.bottomSeparator.width && n2 >= MultiSplitPane.this.bottomSeparator.y && n2 < MultiSplitPane.this.bottomSeparator.y + MultiSplitPane.this.bottomSeparator.height) {
                position = Position.BOTTOM;
                if (MultiSplitPane.this.collapsible && n < MultiSplitPane.this.bottomSeparator.x + 3 * ICON_WIDTH) {
                    blArray[0] = true;
                }
            } else if (MultiSplitPane.this.leftSeparator.width > 0 && n >= MultiSplitPane.this.leftSeparator.x && n < MultiSplitPane.this.leftSeparator.x + MultiSplitPane.this.leftSeparator.width && n2 >= MultiSplitPane.this.leftSeparator.y && n2 < MultiSplitPane.this.leftSeparator.y + MultiSplitPane.this.leftSeparator.height) {
                position = Position.LEFT;
                if (MultiSplitPane.this.collapsible && n2 < MultiSplitPane.this.leftSeparator.y + 3 * ICON_WIDTH) {
                    blArray[0] = true;
                }
            }
            return position;
        }

        private void startDrag(Position position, int n, int n2) {
            int n3 = MultiSplitPane.this.indexOfPosition(position);
            this.resizedComponent = MultiSplitPane.this.getComponent(n3);
            this.resizedConstraints = MultiSplitPane.this.constraints[n3];
            this.dragX = n;
            this.dragY = n2;
            this.dragging = true;
        }

        private void doDrag(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = n - this.dragX;
            int n4 = n2 - this.dragY;
            this.dragX = n;
            this.dragY = n2;
            double d = 0.0;
            switch (this.resizedConstraints.position) {
                case TOP: {
                    d = (double)(this.resizedComponent.getHeight() + n4) / (double)MultiSplitPane.this.availableHeight;
                    break;
                }
                case RIGHT: {
                    d = (double)(this.resizedComponent.getWidth() - n3) / (double)MultiSplitPane.this.availableWidth;
                    break;
                }
                case BOTTOM: {
                    d = (double)(this.resizedComponent.getHeight() - n4) / (double)MultiSplitPane.this.availableHeight;
                    break;
                }
                case LEFT: {
                    d = (double)(this.resizedComponent.getWidth() + n3) / (double)MultiSplitPane.this.availableWidth;
                }
            }
            if (d <= 0.0) {
                d = 1.0E-6;
            } else if (d >= 1.0) {
                d = 0.999999;
            }
            if (this.resizedConstraints.collapsed) {
                this.resizedConstraints.collapsed = false;
                this.resizedConstraints.size = 0.0;
            }
            if (this.resizedConstraints.size != d) {
                this.resizedConstraints.size = d;
                MultiSplitPane.this.revalidate();
                MultiSplitPane.this.repaint();
            }
        }

        private void endDrag(MouseEvent mouseEvent) {
            MultiSplitPane.this.firePaneResized(this.resizedComponent, this.resizedConstraints);
            this.resizedComponent = null;
            this.resizedConstraints = null;
            this.dragY = -1;
            this.dragX = -1;
            this.dragging = false;
        }

        private void startClick(Position position) {
            this.clickedPosition = position;
        }

        private void endClick(MouseEvent mouseEvent) {
            if (this.clickedPosition != null) {
                Position position = this.whichPosition(mouseEvent.getX(), mouseEvent.getY(), this.buttonClicked);
                if (position == this.clickedPosition && this.buttonClicked[0]) {
                    this.toggleCollapsed(position);
                }
                this.clickedPosition = null;
            }
        }

        private void toggleCollapsed(Position position) {
            int n = MultiSplitPane.this.indexOfPosition(position);
            this.resizedConstraints = MultiSplitPane.this.constraints[n];
            this.resizedConstraints.collapsed = !this.resizedConstraints.collapsed;
            MultiSplitPane.this.firePaneResized(MultiSplitPane.this.getComponent(n), this.resizedConstraints);
            this.resizedConstraints = null;
            MultiSplitPane.this.revalidate();
            MultiSplitPane.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2;
            Position position;
            if (MultiSplitPane.this.hasSeparators && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && (position = this.whichPosition(n2 = mouseEvent.getX(), n = mouseEvent.getY(), this.buttonClicked)) != null && !this.buttonClicked[0] && MultiSplitPane.this.collapsible) {
                this.toggleCollapsed(position);
            }
        }
    }

    protected static final class Layout
    implements LayoutManager {
        private LayoutInfo[] infos = new LayoutInfo[5];
        private int infoCount;
        private boolean hasCenter;
        private boolean hasTop;
        private boolean hasRight;
        private boolean hasBottom;
        private boolean hasLeft;
        private boolean hasTopSepar;
        private boolean hasRightSepar;
        private boolean hasBottomSepar;
        private boolean hasLeftSepar;

        public Layout() {
            for (int i = 0; i < 5; ++i) {
                this.infos[i] = new LayoutInfo();
            }
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.layoutSize((MultiSplitPane)container, 1);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.layoutSize((MultiSplitPane)container, 2);
        }

        private Dimension layoutSize(MultiSplitPane multiSplitPane, int n) {
            this.compileInfo(multiSplitPane);
            Dimension dimension = this.infoCount == 0 ? new Dimension(0, 0) : this.doLayoutSize(multiSplitPane, n);
            Insets insets = multiSplitPane.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            if (dimension.width < 1) {
                dimension.width = 1;
            }
            if (dimension.height < 1) {
                dimension.height = 1;
            }
            return dimension;
        }

        private void compileInfo(MultiSplitPane multiSplitPane) {
            this.infoCount = 0;
            this.hasCenter = false;
            this.hasTop = false;
            this.hasRight = false;
            this.hasBottom = false;
            this.hasLeft = false;
            this.hasTopSepar = false;
            this.hasRightSepar = false;
            this.hasBottomSepar = false;
            this.hasLeftSepar = false;
            Component[] componentArray = multiSplitPane.getComponents();
            int n = componentArray.length;
            block7: for (int i = 0; i < n; ++i) {
                Component component = componentArray[i];
                Constraints constraints = multiSplitPane.constraints[i];
                if (constraints.position == Position.CENTER) {
                    constraints.collapsed = false;
                    constraints.size = -1.0;
                }
                if (!component.isVisible()) continue;
                LayoutInfo layoutInfo = this.infos[this.infoCount++];
                layoutInfo.component = component;
                layoutInfo.index = i;
                layoutInfo.position = constraints.position;
                layoutInfo.size = multiSplitPane.collapsible && constraints.collapsed ? 0.0 : constraints.size;
                switch (layoutInfo.position) {
                    case CENTER: {
                        this.hasCenter = true;
                        continue block7;
                    }
                    case TOP: {
                        this.hasTop = true;
                        this.hasTopSepar = true;
                        continue block7;
                    }
                    case RIGHT: {
                        this.hasRight = true;
                        this.hasRightSepar = true;
                        continue block7;
                    }
                    case BOTTOM: {
                        this.hasBottom = true;
                        this.hasBottomSepar = true;
                        continue block7;
                    }
                    case LEFT: {
                        this.hasLeft = true;
                        this.hasLeftSepar = true;
                    }
                }
            }
            if (this.infoCount > 1) {
                Arrays.sort(this.infos, 0, this.infoCount);
            }
        }

        private Dimension doLayoutSize(MultiSplitPane multiSplitPane, int n) {
            Dimension dimension;
            int n2 = this.infoCount - 1;
            if (this.hasCenter) {
                switch (n) {
                    case 1: {
                        dimension = this.infos[n2].component.getMinimumSize();
                        break;
                    }
                    case 2: {
                        dimension = this.infos[n2].component.getPreferredSize();
                        break;
                    }
                    default: {
                        dimension = new Dimension(1, 1);
                    }
                }
                --n2;
            } else {
                dimension = new Dimension(0, 0);
            }
            while (n2 >= 0) {
                Dimension dimension2;
                LayoutInfo layoutInfo = this.infos[n2];
                switch (n) {
                    case 1: {
                        dimension2 = layoutInfo.component.getMinimumSize();
                        break;
                    }
                    case 2: {
                        dimension2 = layoutInfo.component.getPreferredSize();
                        break;
                    }
                    default: {
                        dimension2 = new Dimension(1, 1);
                    }
                }
                switch (layoutInfo.position) {
                    case TOP: 
                    case BOTTOM: {
                        dimension.width = Math.max(dimension2.width, dimension.width);
                        dimension.height += dimension2.height;
                        if (!this.hasTopSepar && !this.hasBottomSepar) break;
                        dimension.width = Math.max(multiSplitPane.separatorSize, dimension.width);
                        dimension.height += multiSplitPane.separatorSize;
                        break;
                    }
                    case LEFT: 
                    case RIGHT: {
                        dimension.width += dimension2.width;
                        dimension.height = Math.max(dimension2.height, dimension.height);
                        if (!this.hasLeftSepar && !this.hasRightSepar) break;
                        dimension.width += multiSplitPane.separatorSize;
                        dimension.height = Math.max(multiSplitPane.separatorSize, dimension.height);
                    }
                }
                --n2;
            }
            return dimension;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void layoutContainer(Container container) {
            void var16_21;
            int n;
            Component[] componentArray;
            MultiSplitPane multiSplitPane = (MultiSplitPane)container;
            Insets insets = multiSplitPane.getInsets();
            int n2 = insets.left;
            int n3 = insets.top;
            int n4 = multiSplitPane.getWidth() - n2 - insets.right;
            int n5 = multiSplitPane.getHeight() - n3 - insets.bottom;
            multiSplitPane.availableWidth = n4;
            multiSplitPane.availableHeight = n5;
            Rectangle rectangle = multiSplitPane.topSeparator;
            Rectangle rectangle2 = multiSplitPane.rightSeparator;
            Rectangle rectangle3 = multiSplitPane.bottomSeparator;
            Rectangle rectangle4 = multiSplitPane.leftSeparator;
            rectangle.width = -1;
            rectangle2.width = -1;
            rectangle3.width = -1;
            rectangle4.width = -1;
            multiSplitPane.hasSeparators = false;
            for (Component component : componentArray = multiSplitPane.getComponents()) {
                component.setBounds(-1, -1, 1, 1);
            }
            this.compileInfo(multiSplitPane);
            if (this.infoCount == 0) {
                return;
            }
            Dimension dimension = this.doLayoutSize(multiSplitPane, 0);
            if (n4 < dimension.width) {
                n4 = dimension.width;
            }
            if (n5 < dimension.height) {
                n5 = dimension.height;
            }
            LayoutInfo layoutInfo = null;
            LayoutInfo layoutInfo2 = null;
            Object var16_20 = null;
            LayoutInfo layoutInfo3 = null;
            block13: for (n = 0; n < this.infoCount; ++n) {
                LayoutInfo layoutInfo4 = this.infos[n];
                switch (layoutInfo4.position) {
                    case TOP: {
                        layoutInfo = layoutInfo4;
                        continue block13;
                    }
                    case RIGHT: {
                        layoutInfo2 = layoutInfo4;
                        continue block13;
                    }
                    case BOTTOM: {
                        LayoutInfo layoutInfo5 = layoutInfo4;
                        continue block13;
                    }
                    case LEFT: {
                        layoutInfo3 = layoutInfo4;
                    }
                }
            }
            n = n4;
            if (this.hasLeft && layoutInfo3.size > 0.0) {
                --n;
            }
            if (this.hasLeftSepar) {
                n -= multiSplitPane.separatorSize;
            }
            if (this.hasCenter) {
                --n;
            }
            if (this.hasRight && layoutInfo2.size > 0.0) {
                --n;
            }
            if (this.hasRightSepar) {
                n -= multiSplitPane.separatorSize;
            }
            int n6 = n5;
            if (this.hasTop && layoutInfo.size > 0.0) {
                --n6;
            }
            if (this.hasTopSepar) {
                n6 -= multiSplitPane.separatorSize;
            }
            if (this.hasCenter) {
                --n6;
            }
            if (this.hasBottom && var16_21.size > 0.0) {
                --n6;
            }
            if (this.hasBottomSepar) {
                n6 -= multiSplitPane.separatorSize;
            }
            multiSplitPane.availableWidth = n;
            multiSplitPane.availableHeight = n6;
            int n7 = n;
            int n8 = n6;
            block14: for (int i = 0; i < this.infoCount; ++i) {
                LayoutInfo layoutInfo6 = this.infos[i];
                switch (layoutInfo6.position) {
                    case TOP: {
                        int n9;
                        if (layoutInfo6.size > 0.0) {
                            n9 = (int)Math.rint(layoutInfo6.size * (double)n6);
                            if (n9 > n8) {
                                n9 = n8;
                            }
                            if (n9 < 1) {
                                n9 = 1;
                            }
                            layoutInfo6.component.setBounds(n2, n3, n4, n9);
                            n5 -= n9;
                            n3 += n9;
                            n8 -= n9;
                        }
                        if (!this.hasTopSepar) continue block14;
                        rectangle.x = n2;
                        rectangle.y = n3;
                        rectangle.width = n4;
                        rectangle.height = multiSplitPane.separatorSize;
                        n5 -= multiSplitPane.separatorSize;
                        n3 += multiSplitPane.separatorSize;
                        n8 -= multiSplitPane.separatorSize;
                        continue block14;
                    }
                    case BOTTOM: {
                        int n10;
                        int n9;
                        if (layoutInfo6.size > 0.0) {
                            n9 = (int)Math.rint(layoutInfo6.size * (double)n6);
                            if (n9 > n8) {
                                n9 = n8;
                            }
                            if (n9 < 1) {
                                n9 = 1;
                            }
                            n10 = n3 + n5 - n9;
                            layoutInfo6.component.setBounds(n2, n10, n4, n9);
                            n5 -= n9;
                            n8 -= n9;
                        } else {
                            n10 = n3 + n5;
                        }
                        if (!this.hasBottomSepar) continue block14;
                        rectangle3.x = n2;
                        rectangle3.y = n10 - multiSplitPane.separatorSize;
                        rectangle3.width = n4;
                        rectangle3.height = multiSplitPane.separatorSize;
                        n5 -= multiSplitPane.separatorSize;
                        n8 -= multiSplitPane.separatorSize;
                        continue block14;
                    }
                    case LEFT: {
                        int n11;
                        if (layoutInfo6.size > 0.0) {
                            n11 = (int)Math.rint(layoutInfo6.size * (double)n);
                            if (n11 > n7) {
                                n11 = n7;
                            }
                            if (n11 < 1) {
                                n11 = 1;
                            }
                            layoutInfo6.component.setBounds(n2, n3, n11, n5);
                            n4 -= n11;
                            n2 += n11;
                            n7 -= n11;
                        }
                        if (!this.hasLeftSepar) continue block14;
                        rectangle4.x = n2;
                        rectangle4.y = n3;
                        rectangle4.width = multiSplitPane.separatorSize;
                        rectangle4.height = n5;
                        n4 -= multiSplitPane.separatorSize;
                        n2 += multiSplitPane.separatorSize;
                        n7 -= multiSplitPane.separatorSize;
                        continue block14;
                    }
                    case RIGHT: {
                        int n12;
                        int n11;
                        if (layoutInfo6.size > 0.0) {
                            n11 = (int)Math.rint(layoutInfo6.size * (double)n);
                            if (n11 > n7) {
                                n11 = n7;
                            }
                            if (n11 < 1) {
                                n11 = 1;
                            }
                            n12 = n2 + n4 - n11;
                            layoutInfo6.component.setBounds(n12, n3, n11, n5);
                            n4 -= n11;
                            n7 -= n11;
                        } else {
                            n12 = n2 + n4;
                        }
                        if (!this.hasRightSepar) continue block14;
                        rectangle2.x = n12 - multiSplitPane.separatorSize;
                        rectangle2.y = n3;
                        rectangle2.width = multiSplitPane.separatorSize;
                        rectangle2.height = n5;
                        n4 -= multiSplitPane.separatorSize;
                        n7 -= multiSplitPane.separatorSize;
                    }
                }
            }
            if (this.hasCenter) {
                this.infos[this.infoCount - 1].component.setBounds(n2, n3, n4, n5);
            }
            multiSplitPane.hasSeparators = rectangle.width > 0 || rectangle2.width > 0 || rectangle3.width > 0 || rectangle4.width > 0;
        }
    }

    protected static final class LayoutInfo
    implements Comparable<LayoutInfo> {
        public Component component;
        public int index;
        public Position position;
        public double size;

        protected LayoutInfo() {
        }

        @Override
        public int compareTo(LayoutInfo layoutInfo) {
            if (this.position == Position.CENTER) {
                return Integer.MAX_VALUE;
            }
            if (layoutInfo.position == Position.CENTER) {
                return Integer.MIN_VALUE;
            }
            return this.index - layoutInfo.index;
        }
    }

    public static final class Constraints
    implements Cloneable {
        public Position position;
        public double size;
        public boolean collapsed;

        public Constraints() {
            this(Position.CENTER, 0.25, false);
        }

        public Constraints(Position position) {
            this(position, 0.25, false);
        }

        public Constraints(Position position, double d) {
            this(position, d, false);
        }

        public Constraints(Position position, double d, boolean bl) {
            this.position = position;
            if (d < 0.0) {
                d = 0.0;
            } else if (d > 1.0) {
                d = 1.0;
            }
            this.size = d;
            this.collapsed = bl;
        }

        public Constraints copy() {
            try {
                return (Constraints)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("MultiSplitPane.Constraints[position=");
            stringBuilder.append((Object)this.position);
            if (this.position != Position.CENTER) {
                stringBuilder.append(", size=");
                stringBuilder.append(this.size);
                stringBuilder.append(", collapsed=");
                stringBuilder.append(this.collapsed);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    public static enum Position {
        CENTER,
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

