/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class MultiLineLabel
extends Component {
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int FLAT = 0;
    public static final int SUNKEN = 1;
    public static final int RAISED = 2;
    private String[] lines = new String[0];
    private int alignment = 1;
    private int relief = 0;
    private int marginWidth = 2;
    private int marginHeight = 2;
    private boolean opaque = true;

    public MultiLineLabel() {
        this("");
    }

    public MultiLineLabel(String string) {
        this(string, 1);
    }

    public MultiLineLabel(String string, int n) {
        this(string, n, 0);
    }

    public MultiLineLabel(String string, int n, int n2) {
        this.setText(string);
        this.setAlignment(n);
        this.setRelief(n2);
    }

    public void setOpaque(boolean bl) {
        this.opaque = bl;
        this.repaint();
    }

    @Override
    public boolean isOpaque() {
        return this.opaque;
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.repaint();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.invalidate();
        this.repaint();
    }

    public void setText(String string) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2 && (n = string.indexOf(10, n4)) >= 0) {
            n4 = n + 1;
            ++n3;
        }
        if (n4 != n2) {
            ++n3;
        }
        this.lines = new String[n3];
        if (n3 > 0) {
            n3 = 0;
            n4 = 0;
            while (n4 < n2 && (n = string.indexOf(10, n4)) >= 0) {
                this.lines[n3++] = string.substring(n4, n);
                n4 = n + 1;
            }
            if (n4 != n2) {
                this.lines[n3] = string.substring(n4);
            }
        }
        this.invalidate();
        this.repaint();
    }

    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.lines) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public void setAlignment(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("invalid alignment");
        }
        this.alignment = n;
        this.repaint();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setRelief(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("invalid relief");
        }
        this.relief = n;
        this.invalidate();
        this.repaint();
    }

    public int getRelief() {
        return this.relief;
    }

    public void setMarginWidth(int n) {
        if (n < 0) {
            n = 0;
        }
        this.marginWidth = n;
        this.invalidate();
        this.repaint();
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public void setMarginHeight(int n) {
        if (n < 0) {
            n = 0;
        }
        this.marginHeight = n;
        this.invalidate();
        this.repaint();
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getHeight();
        int n2 = n * this.lines.length;
        int n3 = 0;
        for (String string : this.lines) {
            int n4;
            if (string.length() <= 0 || (n4 = fontMetrics.stringWidth(string)) <= n3) continue;
            n3 = n4;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        if (n2 == 0) {
            n2 = n;
        }
        int n5 = this.relief == 0 ? 0 : 1;
        return new Dimension(n3 += 2 * (n5 + this.marginWidth), n2 += 2 * (n5 + this.marginHeight));
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        AWTUtil.setTextAntialiasing(graphics);
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getPreferredSize();
        if (dimension.width >= dimension2.width) {
            n4 = 0;
            n3 = dimension.width;
        } else {
            switch (this.alignment) {
                case 0: {
                    n4 = (dimension.width - dimension2.width) / 2;
                    break;
                }
                case 2: {
                    n4 = dimension.width - dimension2.width;
                    break;
                }
                default: {
                    n4 = 0;
                }
            }
            n3 = dimension2.width;
        }
        if (dimension.height >= dimension2.height) {
            n2 = 0;
            n = dimension.height;
        } else {
            n2 = (dimension.height - dimension2.height) / 2;
            n = dimension2.height;
        }
        if (this.opaque) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(n4, n2, n3, n);
            if (this.relief != 0) {
                graphics.draw3DRect(n4, n2, n3 - 1, n - 1, this.relief == 2);
            }
        }
        int n5 = this.relief == 0 ? 0 : 1;
        n4 += n5 + this.marginWidth;
        n2 += n5 + this.marginHeight;
        n3 -= 2 * (n5 + this.marginWidth);
        n -= 2 * (n5 + this.marginHeight);
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n6 = fontMetrics.getMaxAscent();
        int n7 = fontMetrics.getHeight();
        Color color = this.isEnabled() ? this.getForeground() : this.getBackground().darker();
        graphics.setColor(color);
        graphics.setFont(font);
        switch (this.alignment) {
            case 0: {
                for (String string : this.lines) {
                    if (string.length() > 0) {
                        int n8 = fontMetrics.stringWidth(string);
                        graphics.drawString(string, n4 + (n3 - n8) / 2, n2 + n6);
                    }
                    n2 += n7;
                }
                break;
            }
            case 2: {
                for (String string : this.lines) {
                    if (string.length() > 0) {
                        int n9 = fontMetrics.stringWidth(string);
                        graphics.drawString(string, n4 + n3 - n9, n2 + n6);
                    }
                    n2 += n7;
                }
                break;
            }
            default: {
                for (String string : this.lines) {
                    if (string.length() > 0) {
                        graphics.drawString(string, n4, n2 + n6);
                    }
                    n2 += n7;
                }
            }
        }
    }
}

