/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.DialogBase;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.HintLabel;
import com.xmlmind.guiutil.IconResource;
import com.xmlmind.guiutil.Msg;
import com.xmlmind.guiutil.ReorderJList;
import com.xmlmind.util.ArrayUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ItemsSelector
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected JList<Object> selectedList;
    protected JButton selectButton;
    protected JButton unselectButton;
    protected JList<Object> unselectedList;
    protected static final Object[] NO_ITEMS = new Object[0];
    private static Icon defaultIcon;

    public ItemsSelector(int n, int n2) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(DialogUtil.pxBorderLayout(0, 2));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder((Border)null), DialogUtil.pxEmptyBorder(5, 5, 5, 5)));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        this.add((Component)jPanel, DialogUtil.px(gridBagConstraints));
        String string = Msg.msg("IS.selectedItems");
        JLabel jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        jPanel.add((Component)jLabel, "North");
        this.selectedList = new JList(new DefaultListModel());
        this.selectedList.setSelectionMode(2);
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 > 0) {
            stringBuilder.append('x');
            --n2;
        }
        this.selectedList.setPrototypeCellValue(stringBuilder.toString());
        this.selectedList.setVisibleRowCount(n);
        this.selectedList.addListSelectionListener(this);
        this.selectedList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = ItemsSelector.this.selectedList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                    ItemsSelector.this.unselect();
                }
            }
        });
        ReorderJList.initDnD(this.selectedList, true);
        jLabel.setLabelFor(this.selectedList);
        JScrollPane jScrollPane = DialogUtil.createScrollPane(this.selectedList);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel = new JPanel(DialogUtil.pxGridLayout(2, 1, 0, 10));
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        this.add((Component)jPanel, DialogUtil.px(gridBagConstraints));
        IconResource iconResource = new IconResource(ItemsSelector.class, "select.png");
        this.selectButton = new JButton(iconResource);
        this.selectButton.setDisabledIcon(iconResource);
        DialogUtil.setIconic(this.selectButton);
        this.selectButton.setToolTipText(Msg.msg("IS.select"));
        this.selectButton.setActionCommand("select");
        this.selectButton.addActionListener(this);
        jPanel.add(this.selectButton);
        iconResource = new IconResource(ItemsSelector.class, "unselect.png");
        this.unselectButton = new JButton(iconResource);
        this.unselectButton.setDisabledIcon(iconResource);
        DialogUtil.setIconic(this.unselectButton);
        this.unselectButton.setToolTipText(Msg.msg("IS.unselect"));
        this.unselectButton.setActionCommand("unselect");
        this.unselectButton.addActionListener(this);
        jPanel.add(this.unselectButton);
        jPanel = new JPanel(DialogUtil.pxBorderLayout(0, 2));
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        this.add((Component)jPanel, DialogUtil.px(gridBagConstraints));
        string = Msg.msg("IS.unselectedItems");
        jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        jPanel.add((Component)jLabel, "North");
        this.unselectedList = new JList(new DefaultListModel());
        this.unselectedList.setSelectionMode(2);
        this.unselectedList.setPrototypeCellValue(this.selectedList.getPrototypeCellValue());
        this.unselectedList.setVisibleRowCount(n);
        this.unselectedList.addListSelectionListener(this);
        this.unselectedList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = ItemsSelector.this.unselectedList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                    ItemsSelector.this.select();
                }
            }
        });
        ReorderJList.initDnD(this.unselectedList, true);
        jLabel.setLabelFor(this.unselectedList);
        jScrollPane = DialogUtil.createScrollPane(this.unselectedList);
        jPanel.add((Component)jScrollPane, "Center");
        string = Msg.msg("IS.dndHint");
        HintLabel hintLabel = new HintLabel(string);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 5;
        this.add((Component)hintLabel, DialogUtil.px(gridBagConstraints));
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.unselectedList) {
            this.itemsSelectable(this.unselectedList.getSelectedIndices());
        } else if (listSelectionEvent.getSource() == this.selectedList) {
            this.itemsUnselectable(this.selectedList.getSelectedIndices());
        }
    }

    protected void itemsSelectable(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            this.selectButton.setEnabled(false);
        } else {
            this.selectButton.setEnabled(true);
            this.cancelUnselectable();
        }
    }

    protected void itemsUnselectable(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            this.unselectButton.setEnabled(false);
        } else {
            this.unselectButton.setEnabled(true);
            this.cancelSelectable();
        }
    }

    protected void cancelUnselectable() {
        this.selectedList.clearSelection();
        this.itemsUnselectable(null);
    }

    protected void cancelSelectable() {
        this.unselectedList.clearSelection();
        this.itemsSelectable(null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("select")) {
            this.select();
        } else if (string.equals("unselect")) {
            this.unselect();
        }
    }

    protected void select() {
        int[] nArray = this.unselectedList.getSelectedIndices();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        Object[] objectArray = ItemsSelector.getItems(this.unselectedList, nArray);
        Object[] objectArray2 = ItemsSelector.getItems(this.unselectedList);
        objectArray2 = ItemsSelector.removeItems(objectArray2, objectArray);
        ItemsSelector.setListData(this.unselectedList, objectArray2);
        objectArray2 = ItemsSelector.getItems(this.selectedList);
        objectArray2 = ItemsSelector.appendItems(objectArray2, objectArray);
        ItemsSelector.setListData(this.selectedList, objectArray2);
        this.selectedList.ensureIndexIsVisible(objectArray2.length - 1);
        this.cancelSelectable();
    }

    protected static final void setListData(JList<Object> jList, Object[] objectArray) {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        defaultListModel.removeAllElements();
        if (objectArray != null && objectArray.length > 0) {
            for (Object object : objectArray) {
                defaultListModel.addElement(object);
            }
        }
    }

    protected static final Object[] getItems(JList<Object> jList) {
        ListModel<Object> listModel = jList.getModel();
        Object[] objectArray = new Object[listModel.getSize()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = listModel.getElementAt(i);
        }
        return objectArray;
    }

    protected static final Object[] getItems(JList<Object> jList, int[] nArray) {
        ListModel<Object> listModel = jList.getModel();
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = listModel.getElementAt(nArray[i]);
        }
        return objectArray;
    }

    protected static final Object[] removeItems(Object[] objectArray, Object[] objectArray2) {
        Object[] objectArray3 = new Object[objectArray.length];
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            boolean bl = false;
            for (int j = 0; j < objectArray2.length; ++j) {
                if (!object.equals(objectArray2[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            objectArray3[n++] = object;
        }
        if (n != objectArray.length) {
            Object[] objectArray4 = new Object[n];
            System.arraycopy(objectArray3, 0, objectArray4, 0, n);
            objectArray3 = objectArray4;
        }
        return objectArray3;
    }

    protected static final Object[] appendItems(Object[] objectArray, Object[] objectArray2) {
        Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
        return objectArray3;
    }

    protected void unselect() {
        int[] nArray = this.selectedList.getSelectedIndices();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        Object[] objectArray = ItemsSelector.getItems(this.selectedList, nArray);
        Object[] objectArray2 = ItemsSelector.getItems(this.selectedList);
        objectArray2 = ItemsSelector.removeItems(objectArray2, objectArray);
        ItemsSelector.setListData(this.selectedList, objectArray2);
        objectArray2 = ItemsSelector.getItems(this.unselectedList);
        objectArray2 = ItemsSelector.appendItems(objectArray2, objectArray);
        Arrays.sort(objectArray2);
        ItemsSelector.setListData(this.unselectedList, objectArray2);
        this.unselectedList.ensureIndexIsVisible(ArrayUtil.indexOf(objectArray2, objectArray[objectArray.length - 1]));
        this.cancelUnselectable();
    }

    public void setListCellRenderer(ListCellRenderer<Object> listCellRenderer) {
        this.selectedList.setCellRenderer(listCellRenderer);
        this.unselectedList.setCellRenderer(listCellRenderer);
    }

    public void setItems(Object[] objectArray, Object[] objectArray2) {
        Object[] objectArray3;
        if (objectArray == null) {
            objectArray = NO_ITEMS;
        }
        if (objectArray2 == null) {
            objectArray2 = NO_ITEMS;
        }
        if ((objectArray3 = ItemsSelector.removeItems(objectArray, objectArray2)).length > 1) {
            Arrays.sort(objectArray3);
        }
        ItemsSelector.setListData(this.unselectedList, objectArray3);
        this.unselectedList.ensureIndexIsVisible(0);
        ItemsSelector.setListData(this.selectedList, objectArray2);
        this.selectedList.ensureIndexIsVisible(0);
        this.cancelSelectable();
        this.cancelUnselectable();
    }

    public Object[] getItems() {
        return ItemsSelector.getItems(this.selectedList);
    }

    public static Object[] selectItems(Component component, String string, Object[] objectArray, Object[] objectArray2) {
        int n;
        int n2;
        int n3;
        int n4 = 15;
        int n5 = 20;
        if (objectArray != null) {
            n3 = objectArray.length;
            if (n3 > 20) {
                n4 = 20;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                n = objectArray[n2].toString().length();
                if (n <= n5) continue;
                n5 = n;
            }
        }
        if (objectArray2 != null) {
            n3 = objectArray2.length;
            if (n3 > 20) {
                n4 = 20;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                n = objectArray2[n2].toString().length();
                if (n <= n5) continue;
                n5 = n;
            }
        }
        if (n5 > 40) {
            n5 = 40;
        }
        ItemsSelector itemsSelector = new ItemsSelector(n4, n5);
        itemsSelector.setItems(objectArray, objectArray2);
        return ItemsSelector.selectItems(component, string, itemsSelector, ItemsSelector.getDefaultIcon(), null);
    }

    public static Icon getDefaultIcon() {
        if (defaultIcon == null) {
            defaultIcon = new IconResource(ItemsSelector.class, "items.png");
        }
        return defaultIcon;
    }

    public static Object[] selectItems(Component component, String string, ItemsSelector itemsSelector, Icon icon, String string2) {
        int n = 30;
        boolean bl = DialogBase.showDialog(component, string, n, (Component)itemsSelector, itemsSelector.selectedList, icon, string2);
        return bl ? itemsSelector.getItems() : null;
    }

    public static String joinItems(char c, Object ... objectArray) {
        return ItemsSelector.joinItems(Character.toString(c), objectArray);
    }

    public static String joinItems(String string, Object ... objectArray) {
        int n = objectArray.length;
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return objectArray[0].toString();
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(objectArray[0].toString());
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(objectArray[i].toString());
        }
        return stringBuilder.toString();
    }
}

