/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.util.XMLText;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.IdentityHashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;

public final class ImageResource {
    private static final HashMap<URL, BufferedImage> imageCache = new HashMap();
    private static final IdentityHashMap<Image, Image> doubleSizeImages = new IdentityHashMap();

    private ImageResource() {
    }

    public static BufferedImage get(Class<?> clazz, String string) {
        BufferedImage bufferedImage = null;
        URL uRL = clazz.getResource(string);
        if (uRL != null) {
            bufferedImage = ImageResource.get(uRL);
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage get(URL uRL) {
        BufferedImage bufferedImage = null;
        HashMap<URL, BufferedImage> hashMap = imageCache;
        synchronized (hashMap) {
            bufferedImage = imageCache.get(uRL);
            if (bufferedImage == null) {
                int n = AWTUtil.getDisplayScaling();
                if (n <= -145 || n >= 145) {
                    URL uRL2 = ImageResource.insertAtX2(uRL);
                    bufferedImage = ImageResource.read(uRL2);
                }
                boolean bl = false;
                double d = 0.0;
                if (bufferedImage != null) {
                    if (n <= -145) {
                        bl = true;
                    } else if (n != 200) {
                        d = 1.0 + ((double)n - 200.0) / 200.0;
                    }
                } else {
                    bufferedImage = ImageResource.read(uRL);
                    if (n > 100) {
                        d = (double)n / 100.0;
                    }
                }
                if (bufferedImage != null) {
                    if (d > 0.0) {
                        bufferedImage = ImageResource.rescaleImage(bufferedImage, d);
                    }
                    imageCache.put(uRL, bufferedImage);
                    if (bl) {
                        doubleSizeImages.put(bufferedImage, bufferedImage);
                    }
                }
            }
        }
        return bufferedImage;
    }

    public static URL insertAtX2(URL uRL) {
        try {
            uRL = URLUtil.newURL(ImageResource.insertAtX2(uRL.toExternalForm()));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    public static String insertAtX2(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string.substring(0, n));
            stringBuilder.append("@x2");
            stringBuilder.append(string.substring(n));
            string = stringBuilder.toString();
        }
        return string;
    }

    static BufferedImage read(URL uRL) {
        BufferedImage bufferedImage = null;
        try (InputStream inputStream = uRL.openStream();){
            bufferedImage = ImageIO.read(inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BufferedImage rescaleImage(BufferedImage bufferedImage, double d) {
        int n = (int)Math.rint((double)bufferedImage.getWidth() * d);
        int n2 = (int)Math.rint((double)bufferedImage.getHeight() * d);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            Object object = d >= 1.0 ? RenderingHints.VALUE_INTERPOLATION_BICUBIC : RenderingHints.VALUE_INTERPOLATION_BILINEAR;
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public static BufferedImage get(Class<?> clazz, String string, Color color, Color color2) {
        BufferedImage bufferedImage = null;
        URL uRL = clazz.getResource(string);
        if (uRL != null) {
            bufferedImage = ImageResource.get(uRL, color, color2);
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage get(URL uRL, Color color, Color color2) {
        if (color == null && color2 == null) {
            return ImageResource.get(uRL);
        }
        URL uRL2 = uRL;
        String string = uRL.toExternalForm();
        int n = string.lastIndexOf(63);
        if (n >= 0) {
            string = string.substring(0, n);
            try {
                uRL2 = URLUtil.newURL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('?');
        if (color != null) {
            stringBuilder.append("fg=");
            stringBuilder.append(AWTUtil.toHexString(color));
        }
        if (color2 != null) {
            if (color != null) {
                stringBuilder.append('&');
            }
            stringBuilder.append("bg=");
            stringBuilder.append(AWTUtil.toHexString(color2));
        }
        try {
            uRL = URLUtil.newURL(stringBuilder.toString());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        BufferedImage bufferedImage = null;
        HashMap<URL, BufferedImage> hashMap = imageCache;
        synchronized (hashMap) {
            BufferedImage bufferedImage2;
            bufferedImage = imageCache.get(uRL);
            if (bufferedImage == null && (bufferedImage2 = ImageResource.get(uRL2)) != null) {
                bufferedImage = ImageResource.colorizeImage(bufferedImage2, color, color2);
                imageCache.put(uRL, bufferedImage);
                if (doubleSizeImages.containsKey(bufferedImage2)) {
                    doubleSizeImages.put(bufferedImage, bufferedImage);
                }
            }
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage colorizeImage(BufferedImage bufferedImage, Color color, Color color2) {
        Object object;
        BufferedImage bufferedImage2 = AWTUtil.toBufferedImage(bufferedImage, 2);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (color != null) {
            int n3 = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
            object = bufferedImage2.getRGB(0, 0, n, n2, null, 0, n);
            int n4 = ((Object)object).length;
            assert (n4 == n * n2);
            for (int i = 0; i < n4; ++i) {
                int n5 = object[i] & 0xFF000000;
                if (n5 == 0) continue;
                object[i] = n5 | n3;
            }
            bufferedImage2.setRGB(0, 0, n, n2, (int[])object, 0, n);
        }
        if (color2 != null) {
            BufferedImage bufferedImage3 = new BufferedImage(n, n2, 2);
            object = bufferedImage3.createGraphics();
            try {
                ((Graphics)object).setColor(color2);
                ((Graphics)object).fillRect(0, 0, n, n2);
                ((Graphics)object).drawImage(bufferedImage2, 0, 0, null);
            }
            finally {
                ((Graphics)object).dispose();
            }
            bufferedImage2 = bufferedImage3;
        }
        return bufferedImage2;
    }

    public static void appendHTMLImg(Class<?> clazz, String string, StringBuilder stringBuilder) {
        ImageResource.appendHTMLImg(clazz.getResource(string), stringBuilder);
    }

    public static void appendHTMLImg(URL uRL, StringBuilder stringBuilder) {
        if (uRL != null) {
            Object object;
            stringBuilder.append("<img border=\"0\" src=");
            URL uRL2 = uRL;
            boolean bl = false;
            int n = AWTUtil.getDisplayScaling();
            if (n >= 145 && URLUtil.exists((URL)(object = ImageResource.insertAtX2(uRL)))) {
                uRL2 = object;
                bl = true;
            }
            XMLText.quoteXML(uRL2.toExternalForm(), stringBuilder);
            if (!(n <= 100 || n == 200 && bl || (object = ImageResource.get(uRL)) == null)) {
                stringBuilder.append(" width=\"");
                stringBuilder.append(((Image)object).getWidth(null));
                stringBuilder.append("\" height=\"");
                stringBuilder.append(((Image)object).getHeight(null));
                stringBuilder.append('\"');
            }
            stringBuilder.append(" >");
        }
    }

    public static int getImageWidth(Image image) {
        int n = image.getWidth(null);
        if (ImageResource.isDoubleSizeImage(image)) {
            n /= 2;
        }
        return n;
    }

    public static int getImageHeight(Image image) {
        int n = image.getHeight(null);
        if (ImageResource.isDoubleSizeImage(image)) {
            n /= 2;
        }
        return n;
    }

    public static void drawImage(Graphics graphics, Image image, int n, int n2) {
        if (ImageResource.isDoubleSizeImage(image)) {
            ImageResource.drawDoubleSizeImage(graphics, image, n, n2);
        } else {
            graphics.drawImage(image, n, n2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDoubleSizeImage(Image image) {
        HashMap<URL, BufferedImage> hashMap = imageCache;
        synchronized (hashMap) {
            return doubleSizeImages.containsKey(image);
        }
    }

    public static Image downscaleDoubleSizeImage(Image image) {
        assert (ImageResource.isDoubleSizeImage(image));
        return ImageResource.rescaleImage((BufferedImage)image, 0.5);
    }

    public static void drawDoubleSizeImage(Graphics graphics, Image image, int n, int n2) {
        assert (ImageResource.isDoubleSizeImage(image));
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.translate(n, n2);
        graphics2D.scale(0.5, 0.5);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
    }

    public static void drawPattern(Graphics graphics, Image image, int n, int n2, int n3, int n4) {
        if (ImageResource.isDoubleSizeImage(image)) {
            image = ImageResource.downscaleDoubleSizeImage(image);
        }
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        for (int i = 0; i < n4; i += n6) {
            int n7 = Math.min(n6, n4 - i);
            for (int j = 0; j < n3; j += n5) {
                int n8 = Math.min(n5, n3 - j);
                graphics.drawImage(image, n + j, n2 + i, n + j + n8, n2 + i + n7, 0, 0, n8, n7, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image createDisabledImage(Image image) {
        Image image2 = image;
        HashMap<URL, BufferedImage> hashMap = imageCache;
        synchronized (hashMap) {
            ImageIcon imageIcon = new ImageIcon(image);
            Icon icon = UIManager.getLookAndFeel().getDisabledIcon(new JButton(), imageIcon);
            if (icon != null && icon instanceof ImageIcon) {
                image2 = ((ImageIcon)icon).getImage();
            }
            if (doubleSizeImages.containsKey(image)) {
                doubleSizeImages.put(image2, image2);
            }
        }
        return image2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image horizontalFlipImage(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(-1.0, 1.0);
        affineTransform.translate(-n, 0.0);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.drawImage(image, affineTransform, null);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }
}

