/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.ImageResource;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.URLUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class ImagePreview
extends JComponent
implements PropertyChangeListener {
    protected static PreviewFactory previewFactory = new PreviewFactoryImpl();
    protected static WeakHashMap<URL, Cached> cache = new WeakHashMap();
    public static final int DEFAULT_CACHE_CAPACITY = 100;
    protected static int cacheCapacity = 100;
    protected static int preferredPreviewSize;
    protected Component fileChooser;
    protected URL previewImageURL;
    protected Image previewImage;

    public static void setPreviewFactory(PreviewFactory previewFactory) {
        if (previewFactory == null) {
            previewFactory = new PreviewFactoryImpl();
        }
        ImagePreview.previewFactory = previewFactory;
    }

    public static PreviewFactory getPreviewFactory() {
        return previewFactory;
    }

    public static void setCacheCapacity(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n != cacheCapacity) {
            cacheCapacity = n;
            cache.clear();
        }
    }

    public static int getCacheCapacity() {
        return cacheCapacity;
    }

    protected static Image fetchPreview(URL uRL) {
        Image image = null;
        Cached cached = cache.get(uRL);
        if (cached != null) {
            if (cached.imageDate <= 0L || cached.imageDate != URLUtil.lastModified(uRL)) {
                cache.remove(uRL);
                cached = null;
            }
            if (cached != null) {
                image = cached.image;
                cached.touch();
            }
        }
        return image;
    }

    protected static void cachePreview(URL uRL, Image image) {
        int n = cache.size() + 1 - cacheCapacity;
        if (n > 0) {
            Object[] objectArray = cache.entrySet().toArray();
            Arrays.sort(objectArray, new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    Map.Entry entry = (Map.Entry)object;
                    Map.Entry entry2 = (Map.Entry)object2;
                    return ((Cached)entry.getValue()).compareTo((Cached)entry2.getValue());
                }
            });
            for (int i = 0; i < n; ++i) {
                Map.Entry entry = (Map.Entry)objectArray[i];
                URL uRL2 = (URL)entry.getKey();
                cache.remove(uRL2);
            }
        }
        cache.put(uRL, new Cached(image, URLUtil.lastModified(uRL)));
    }

    public static void setPreviewSize(int n) {
        if (n < 16) {
            n = 16;
        }
        if (n != preferredPreviewSize) {
            preferredPreviewSize = n;
            cache.clear();
        }
    }

    public static int getPreviewSize() {
        if (preferredPreviewSize == 0) {
            preferredPreviewSize = AWTUtil.px(128);
        }
        return preferredPreviewSize;
    }

    public ImagePreview() {
        this.setBorder(BorderFactory.createCompoundBorder(DialogUtil.pxEmptyBorder(0, 2, 0, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder((String)null), DialogUtil.pxEmptyBorder(3, 3, 3, 3))));
        Dimension dimension = new Dimension();
        dimension.width = dimension.height = ImagePreview.getPreviewSize();
        Insets insets = this.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        this.setPreferredSize(dimension);
    }

    public void setFileChooser(Component component) {
        this.preview(null);
        if (this.fileChooser != null) {
            this.fileChooser.removePropertyChangeListener(this);
            this.fileChooser = null;
        }
        if (component != null) {
            this.fileChooser = component;
            this.fileChooser.addPropertyChangeListener(this);
        }
    }

    public Component getFileChooser() {
        return this.fileChooser;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("SelectedFileChangedProperty".equals(string)) {
            Object object = propertyChangeEvent.getNewValue();
            if (object == null) {
                this.preview(null);
            } else {
                String string2;
                URL uRL = null;
                if (object instanceof File) {
                    File file = (File)object;
                    if (file.isFile()) {
                        uRL = FileUtil.fileToURL(file);
                    }
                } else if (object instanceof URL && ((string2 = URLUtil.getRawExtension(uRL = (URL)object)) == null || string2.length() == 0)) {
                    uRL = null;
                }
                if (uRL != null) {
                    this.preview(uRL);
                }
            }
        } else if ("directoryChanged".equals(string)) {
            this.preview(null);
        }
    }

    protected void preview(URL uRL) {
        this.previewImageURL = uRL;
        this.previewImage = null;
        if (uRL != null) {
            Object object;
            this.previewImage = ImagePreview.fetchPreview(uRL);
            if (this.previewImage == null && (object = previewFactory.canCreatePreview(uRL)) != null) {
                int n = ImagePreview.getPreviewSize();
                this.previewImage = previewFactory.createPreview(object, uRL, n, n);
                if (this.previewImage != null) {
                    ImagePreview.cachePreview(uRL, this.previewImage);
                }
            }
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Image image = this.previewImage;
        if (image != null) {
            Insets insets = this.getInsets();
            int n = insets.left + (this.getWidth() - (insets.left + insets.right) - image.getWidth(null)) / 2;
            int n2 = insets.top + (this.getHeight() - (insets.top + insets.bottom) - image.getHeight(null)) / 2;
            ImageResource.drawImage(graphics, image, n, n2);
        }
    }

    protected static final class Cached
    implements Comparable<Cached> {
        public final Image image;
        public final long imageDate;
        private long fetchDate;

        public Cached(Image image, long l) {
            this.image = image;
            this.imageDate = l;
            this.touch();
        }

        public void touch() {
            this.fetchDate = System.currentTimeMillis();
        }

        @Override
        public int compareTo(Cached cached) {
            long l = this.fetchDate - cached.fetchDate;
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
    }

    protected static final class PreviewFactoryImpl
    implements PreviewFactory {
        protected PreviewFactoryImpl() {
        }

        @Override
        public Object canCreatePreview(URL uRL) {
            String string = URLUtil.getExtension(uRL);
            if (string == null) {
                return null;
            }
            string = string.toLowerCase();
            ImageReader imageReader = null;
            Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string);
            if (iterator.hasNext()) {
                imageReader = iterator.next();
            }
            return imageReader;
        }

        @Override
        public Image createPreview(Object object, URL uRL, int n, int n2) {
            Image image = null;
            try {
                image = this.loadImage((ImageReader)object, uRL);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (image != null) {
                int n3 = image.getWidth(null);
                int n4 = image.getHeight(null);
                if (n3 > 0 && n4 > 0) {
                    int n5;
                    double d;
                    double d2;
                    double d3 = Math.min(n3, n);
                    double d4 = d3 / (double)n3;
                    double d5 = Math.min(d4, d2 = (d = (double)Math.min(n4, n2)) / (double)n4);
                    int n6 = (int)Math.rint((double)n3 * d5);
                    if (n6 <= 0) {
                        n6 = 1;
                    }
                    if ((n5 = (int)Math.rint((double)n4 * d5)) <= 0) {
                        n5 = 1;
                    }
                    if (n6 != n3 || n5 != n4) {
                        image = AWTUtil.getScaledImage(image, n6, n5, true);
                    }
                }
            }
            return image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Image loadImage(ImageReader imageReader, URL uRL) throws Exception {
            BufferedImage bufferedImage = null;
            try (InputStream inputStream = URLUtil.openStreamNoCache(uRL);){
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
                if (imageInputStream == null) {
                    throw new RuntimeException("cannot create an ImageInputStream out of a java.io.InputStream");
                }
                try {
                    ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                    imageReader.setInput(imageInputStream, true, true);
                    bufferedImage = imageReader.read(0, imageReadParam);
                }
                finally {
                    imageInputStream.close();
                }
            }
            finally {
                imageReader.dispose();
            }
            return bufferedImage;
        }
    }

    public static interface PreviewFactory {
        public Object canCreatePreview(URL var1);

        public Image createPreview(Object var1, URL var2, int var3, int var4);
    }
}

