/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.Msg;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.URLUtil;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import javax.swing.filechooser.FileFilter;

public final class FilterByExtension
extends FileFilter {
    private String[] suffixes;
    private String description;

    public static FilterByExtension create(URL uRL) {
        String string = URLUtil.getExtension(uRL);
        if (string != null && string.length() > 0) {
            return new FilterByExtension(string);
        }
        return null;
    }

    public static FilterByExtension create(File file) {
        String string = FileUtil.getExtension(file.getPath());
        if (string != null && string.length() > 0) {
            return new FilterByExtension(string);
        }
        return null;
    }

    public FilterByExtension(String ... stringArray) {
        int n = stringArray.length;
        this.suffixes = new String[n];
        for (int i = 0; i < n; ++i) {
            this.suffixes[i] = "." + stringArray[i].toLowerCase();
        }
        Arrays.sort(this.suffixes);
    }

    public String getFileNameSuffix() {
        return this.suffixes[0];
    }

    public String[] getFileNameSuffixes() {
        return this.suffixes;
    }

    public boolean acceptsExtension(String string) {
        Object object = string.startsWith(".") ? string : "." + string;
        for (String string2 : this.suffixes) {
            if (!string2.equalsIgnoreCase((String)object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = file.getName().toLowerCase();
        for (String string2 : this.suffixes) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        int n = this.suffixes.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.suffixes[i].substring(1).toUpperCase();
        }
        return Msg.msg("FBE.fileWithExtension", StringUtil.join(',', stringArray));
    }

    public String toString() {
        return this.getDescription();
    }

    public int hashCode() {
        int n = this.suffixes[0].hashCode();
        int n2 = this.suffixes.length;
        for (int i = 1; i < n2; ++i) {
            n ^= this.suffixes[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FilterByExtension)) {
            return false;
        }
        return Arrays.equals(this.suffixes, ((FilterByExtension)object).suffixes);
    }
}

