/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.Msg;
import com.xmlmind.guiutil.TextIcon;
import com.xmlmind.guiutil.ZebraRenderer;
import com.xmlmind.util.Console;
import com.xmlmind.util.ObjectUtil;
import com.xmlmind.util.ProgressMonitor;
import com.xmlmind.util.SystemUtil;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public final class AutoCompletion
implements FocusListener,
ComponentListener,
HierarchyBoundsListener,
DocumentListener,
KeyListener,
ActionListener,
Runnable {
    public static final NoChoices NO_CHOICES = new NoChoices();
    public static final ChoiceRenderer CHOICE_RENDERER = new ChoiceRenderer();
    public static final RichChoiceRenderer RICH_CHOICE_RENDERER = new RichChoiceRenderer();
    private static boolean preferMinimalChoices = false;
    private static AutoSuggest defaultAutoSuggest = AutoSuggest.YES;
    private static AppendMode defaultAppendMode = AppendMode.MANUAL;
    private static AWTKeyStroke[] defaultAppendKeyStrokes = new AWTKeyStroke[]{AWTKeyStroke.getAWTKeyStroke(112, 0)};
    private static int defaultVisibleSuggestionCount = 5;
    private static final int FIRST_KEY_CHAR1 = 32;
    private static final int LAST_KEY_CHAR1 = 126;
    private static final int FIRST_KEY_CHAR2 = 160;
    private static final int LAST_KEY_CHAR2 = 55295;
    private static final Object[] NO_DATA = new Object[0];
    public static final AWTKeyStroke[] KEY_STROKES1 = new AWTKeyStroke[]{AWTKeyStroke.getAWTKeyStroke(32, 128)};
    public static final AWTKeyStroke[] KEY_STROKES2 = new AWTKeyStroke[]{AWTKeyStroke.getAWTKeyStroke(32, 128), AWTKeyStroke.getAWTKeyStroke(' ')};
    private JTextField entry;
    private JList<Object> listbox;
    private Choices choices;
    private AutoSuggest autoSuggest;
    private AppendMode appendMode;
    private AWTKeyStroke[] appendKeyStrokes;
    private int visibleSuggestionCount;
    private boolean appendOnAccept;
    private ChoiceList choiceList;
    private boolean working;
    private Popup popup;
    private boolean showingPopup;
    private JScrollPane popupScrollPane;
    private JList<Object> popupList;

    public static final String toString(Object object) {
        return object == null || object instanceof PossibleChoice && !((PossibleChoice)object).isPossibleChoice() ? null : object.toString();
    }

    public static void simpleChoiceList(Object[] objectArray, String string, ChoiceList choiceList) {
        choiceList.list = objectArray;
        choiceList.first = -1;
        if (string.length() == 0) {
            return;
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = objectArray[i].toString();
            if (!string2.startsWith(string)) continue;
            choiceList.first = i;
            return;
        }
    }

    public static void minimalChoiceList(Object[] objectArray, String string, ChoiceList choiceList) {
        int n = objectArray.length;
        if (string.length() == 0 || (n = objectArray.length) == 0) {
            choiceList.list = objectArray;
            choiceList.first = -1;
            return;
        }
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            String string2 = object.toString();
            if (!string2.startsWith(string)) continue;
            objectArray2[n2++] = object;
        }
        if (n2 != n) {
            Object[] objectArray3 = new Object[n2];
            System.arraycopy(objectArray2, 0, objectArray3, 0, n2);
            objectArray2 = objectArray3;
        }
        choiceList.list = objectArray2;
        choiceList.first = n2 > 0 ? 0 : -1;
    }

    public static void setPreferMinimalChoices(boolean bl) {
        preferMinimalChoices = bl;
    }

    public static boolean getPreferMinimalChoices() {
        return preferMinimalChoices;
    }

    public static void setDefaultAutoSuggest(AutoSuggest autoSuggest) {
        if (autoSuggest == AutoSuggest.UNSPECIFIED) {
            autoSuggest = AutoSuggest.NO;
        }
        defaultAutoSuggest = autoSuggest;
    }

    public static AutoSuggest getDefaultAutoSuggest() {
        return defaultAutoSuggest;
    }

    public static void setDefaultAppendMode(AppendMode appendMode) {
        if (appendMode == AppendMode.UNSPECIFIED) {
            appendMode = AppendMode.NONE;
        }
        defaultAppendMode = appendMode;
    }

    public static AppendMode getDefaultAppendMode() {
        return defaultAppendMode;
    }

    public static void setDefaultAppendKeyStrokes(AWTKeyStroke[] aWTKeyStrokeArray) {
        if (aWTKeyStrokeArray == null) {
            aWTKeyStrokeArray = new AWTKeyStroke[]{};
        }
        defaultAppendKeyStrokes = aWTKeyStrokeArray;
    }

    public static AWTKeyStroke[] getDefaultAppendKeyStrokes() {
        return defaultAppendKeyStrokes;
    }

    public static void setDefaultVisibleSuggestionCount(int n) {
        if (n < 2) {
            n = 2;
        }
        defaultVisibleSuggestionCount = n;
    }

    public static int getDefaultVisibleSuggestionCount() {
        return defaultVisibleSuggestionCount;
    }

    public AutoCompletion() {
        this(null);
    }

    public AutoCompletion(JTextField jTextField) {
        this.setTextField(jTextField);
        this.autoSuggest = AutoSuggest.UNSPECIFIED;
        this.appendMode = AppendMode.UNSPECIFIED;
        this.choiceList = new ChoiceList();
    }

    public void setTextField(JTextField jTextField) {
        this.destroyPopup();
        if (this.entry != null) {
            this.entry.removeActionListener(this);
            this.entry.removeFocusListener(this);
            this.entry.removeComponentListener(this);
            this.entry.removeHierarchyBoundsListener(this);
            this.entry.getDocument().removeDocumentListener(this);
            this.entry.removeKeyListener(this);
            this.entry = null;
        }
        if (jTextField != null) {
            this.entry = jTextField;
            this.entry.addActionListener(this);
            this.entry.addFocusListener(this);
            this.entry.addComponentListener(this);
            this.entry.addHierarchyBoundsListener(this);
            this.entry.getDocument().addDocumentListener(this);
            this.entry.addKeyListener(this);
        }
    }

    private void destroyPopup() {
        if (this.showingPopup) {
            return;
        }
        this.hidePopup();
        if (this.popupList != null) {
            this.popupList = null;
            this.popupScrollPane = null;
        }
    }

    private void hidePopup() {
        if (this.popup != null) {
            if (this.popupList != null) {
                this.popupList.setListData((Object[])NO_DATA);
                AutoCompletion.ensureIndexIsVisible(this.popupList, 0);
            }
            this.popup.hide();
            this.popup = null;
            this.showingPopup = false;
        }
    }

    public JTextField getTextField() {
        return this.entry;
    }

    public static final void ensureIndexIsVisible(JList<Object> jList, int n) {
        jList.ensureIndexIsVisible(n + 1);
        jList.ensureIndexIsVisible(n);
    }

    public void setList(JList<Object> jList) {
        this.destroyPopup();
        this.listbox = jList;
    }

    public JList<Object> getList() {
        return this.listbox;
    }

    public void setChoices(Choices choices) {
        if (this.listbox != null) {
            this.listbox.setListData((Object[])NO_DATA);
            AutoCompletion.ensureIndexIsVisible(this.listbox, 0);
        } else {
            this.destroyPopup();
        }
        this.choices = choices;
    }

    public Choices getChoices() {
        return this.choices;
    }

    public void listChoices(String string, ChoiceList choiceList) {
        if (this.choices != null) {
            if (this.choices instanceof SlowChoices && this.entry instanceof ProgressTextField) {
                ((SlowChoices)this.choices).getChoices(string, choiceList, (ProgressTextField)this.entry);
            } else {
                this.choices.getChoices(string, choiceList);
            }
        }
    }

    public void setAutoSuggest(AutoSuggest autoSuggest) {
        this.destroyPopup();
        this.autoSuggest = autoSuggest;
    }

    public AutoSuggest getAutoSuggest() {
        return this.autoSuggest;
    }

    private AutoSuggest autoSuggest() {
        return this.autoSuggest == AutoSuggest.UNSPECIFIED ? defaultAutoSuggest : this.autoSuggest;
    }

    public void setAppendMode(AppendMode appendMode) {
        this.destroyPopup();
        this.appendMode = appendMode;
    }

    public AppendMode getAppendMode() {
        return this.appendMode;
    }

    private AppendMode appendMode() {
        return this.appendMode == AppendMode.UNSPECIFIED ? defaultAppendMode : this.appendMode;
    }

    public void setAppendKeyStrokes(AWTKeyStroke[] aWTKeyStrokeArray) {
        this.destroyPopup();
        this.appendKeyStrokes = aWTKeyStrokeArray;
    }

    public AWTKeyStroke[] getAppendKeyStrokes() {
        return this.appendKeyStrokes;
    }

    private AWTKeyStroke[] appendKeyStrokes() {
        return this.appendKeyStrokes == null ? defaultAppendKeyStrokes : this.appendKeyStrokes;
    }

    public void setVisibleSuggestionCount(int n) {
        this.destroyPopup();
        this.visibleSuggestionCount = n;
    }

    public int getVisibleSuggestionCount() {
        return this.visibleSuggestionCount;
    }

    private int visibleSuggestionCount() {
        return this.visibleSuggestionCount <= 0 ? defaultVisibleSuggestionCount : this.visibleSuggestionCount;
    }

    public void setAppendOnAccept(boolean bl) {
        this.appendOnAccept = bl;
    }

    public boolean getAppendOnAccept() {
        return this.appendOnAccept;
    }

    public void setEntry(String string) {
        this.working = true;
        if (string == null) {
            string = "";
        }
        this.entry.setText(string);
        this.entry.setCaretPosition(string.length());
        this.working = false;
    }

    public String acceptEntry() {
        if (this.appendOnAccept) {
            this.appendOnAccept();
        }
        return this.entry.getText();
    }

    private void appendOnAccept() {
        int n;
        String string = this.entry.getText();
        if (string.length() == 0) {
            return;
        }
        this.listChoices(string, this.choiceList);
        if (this.choiceList.first < 0 || (n = this.choiceList.list.length) == 0) {
            return;
        }
        for (int i = this.choiceList.first; i < n; ++i) {
            String string2 = AutoCompletion.toString(this.choiceList.list[i]);
            if (string2 == null || !string2.startsWith(string)) continue;
            if (string2.equals(string)) break;
            this.setEntry(string2);
            break;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.hidePopup();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.hidePopup();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.destroyPopup();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.destroyPopup();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.destroyPopup();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        System.err.println(componentEvent);
        this.destroyPopup();
    }

    @Override
    public void ancestorMoved(HierarchyEvent hierarchyEvent) {
        this.destroyPopup();
    }

    @Override
    public void ancestorResized(HierarchyEvent hierarchyEvent) {
        this.destroyPopup();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.choices != null && this.autoSuggest() == AutoSuggest.YES && !this.working) {
            this.suggest();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.choices != null && this.autoSuggest() == AutoSuggest.YES && !this.working) {
            this.suggest();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void suggest() {
        String string = this.entry.getText();
        this.listChoices(string, this.choiceList);
        if (this.choiceList.first < 0 && string.length() > 0 && this.listbox == null) {
            this.hidePopup();
            return;
        }
        JList<Object> jList = this.listbox();
        if (this.choices.choiceListDependsOnPrefix() || jList.getModel().getSize() != this.choiceList.list.length) {
            jList.setListData((Object[])this.choiceList.list);
        }
        if (this.choiceList.first < 0) {
            AutoCompletion.ensureIndexIsVisible(jList, 0);
            jList.clearSelection();
        } else {
            AutoCompletion.ensureIndexIsVisible(jList, this.choiceList.first);
            jList.setSelectedIndex(this.choiceList.first);
        }
    }

    private JList<Object> listbox() {
        Object object;
        if (this.listbox != null) {
            return this.listbox;
        }
        if (this.popupList == null) {
            this.popupList = new JList();
            this.popupList.setSelectionMode(0);
            this.popupList.setVisibleRowCount(this.visibleSuggestionCount());
            this.popupList.setCellRenderer(CHOICE_RENDERER);
            this.popupList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Object object;
                    String string;
                    int n;
                    if (mouseEvent.getClickCount() == 1 && (n = AutoCompletion.this.popupList.locationToIndex(mouseEvent.getPoint())) >= 0 && (string = AutoCompletion.toString(object = AutoCompletion.this.popupList.getModel().getElementAt(n))) != null) {
                        AutoCompletion.this.setEntry(string);
                        AutoCompletion.this.hidePopup();
                    }
                }
            });
            this.popupScrollPane = DialogUtil.createScrollPane(this.popupList);
            object = this.popupScrollPane.getPreferredSize();
            ((Dimension)object).width = this.entry.getWidth();
            this.popupScrollPane.setPreferredSize((Dimension)object);
            AWTUtil.setFocusable(this.popupScrollPane, false);
        }
        if (this.popup == null) {
            object = PopupFactory.getSharedInstance();
            Point point = this.entry.getLocationOnScreen();
            this.popup = ((PopupFactory)object).getPopup(this.entry, this.popupScrollPane, point.x, point.y + this.entry.getHeight());
            this.showingPopup = true;
            try {
                this.popup.show();
            }
            finally {
                this.showingPopup = false;
            }
        }
        return this.popupList;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.choices != null) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 27: {
                    if (this.popup == null) break;
                    keyEvent.consume();
                    this.hidePopup();
                    break;
                }
                case 38: 
                case 40: {
                    if (this.autoSuggest() != AutoSuggest.YES) break;
                    keyEvent.consume();
                    this.selectFromList(n == 38);
                    break;
                }
                case 10: {
                    if (this.appendOnAccept) {
                        this.appendOnAccept();
                        break;
                    }
                }
                default: {
                    if (this.appendMode() != AppendMode.MANUAL || !this.isAppendKeyStroke(keyEvent)) break;
                    keyEvent.consume();
                    this.manualAppend();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.choices != null && this.appendMode() == AppendMode.MANUAL && this.isAppendKeyStroke(keyEvent)) {
            keyEvent.consume();
            this.manualAppend();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.choices != null) {
            switch (this.appendMode()) {
                case MANUAL: {
                    if (!this.isAppendKeyStroke(keyEvent)) break;
                    keyEvent.consume();
                    this.manualAppend();
                    break;
                }
                case AUTO: {
                    char c;
                    int n = keyEvent.getModifiers();
                    if ((SystemUtil.IS_MAC_OS || (n & 8) != (n & 2)) && (!SystemUtil.IS_MAC_OS || (n & 6) != 0) || !((c = keyEvent.getKeyChar()) >= ' ' && c <= '~' || c >= '\u00a0' && c <= '\ud7ff') && (c < '\ue000' || c > '\ufffd')) break;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }

    private boolean isAppendKeyStroke(KeyEvent keyEvent) {
        AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent);
        AWTKeyStroke[] aWTKeyStrokeArray = this.appendKeyStrokes();
        int n = aWTKeyStrokeArray.length;
        for (int i = 0; i < n; ++i) {
            if (!aWTKeyStroke.equals(aWTKeyStrokeArray[i])) continue;
            return true;
        }
        return false;
    }

    private void selectFromList(boolean bl) {
        JList<Object> jList = this.listbox();
        String string = this.entry.getText();
        ListModel<Object> listModel = jList.getModel();
        int n = listModel.getSize();
        if (n == 0) {
            this.listChoices(string, this.choiceList);
            jList.setListData((Object[])this.choiceList.list);
            int n2 = this.choiceList.first >= 0 ? this.choiceList.first : 0;
            AutoCompletion.ensureIndexIsVisible(jList, n2);
            jList.setSelectedIndex(n2);
            return;
        }
        int n3 = jList.getSelectedIndex();
        if (n3 < 0) {
            AutoCompletion.ensureIndexIsVisible(jList, 0);
            jList.setSelectedIndex(0);
            return;
        }
        Object object = listModel.getElementAt(n3);
        String string2 = AutoCompletion.toString(object);
        if (string2 == null || string.equals(string2)) {
            n3 = bl ? --n3 : ++n3;
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 >= n) {
                n3 = n - 1;
            }
            object = listModel.getElementAt(n3);
            jList.setSelectedIndex(n3);
        }
        AutoCompletion.ensureIndexIsVisible(jList, n3);
        string2 = AutoCompletion.toString(object);
        if (string2 != null) {
            this.setEntry(string2);
            this.entry.selectAll();
        }
    }

    private void manualAppend() {
        int n;
        String string = this.entry.getText();
        this.listChoices(string, this.choiceList);
        if (this.choiceList.first < 0 || (n = this.choiceList.list.length) == 0) {
            return;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        for (int i = this.choiceList.first; i < n; ++i) {
            String string2 = AutoCompletion.toString(this.choiceList.list[i]);
            if (string2 == null || !string2.startsWith(string)) continue;
            stringArray[n2++] = string2;
        }
        if (n2 == 0) {
            return;
        }
        Object object = string;
        int n3 = string.length();
        String string3 = stringArray[0];
        int n4 = string3.length();
        block1: for (int i = n3; i < n4; ++i) {
            String string4 = (String)object + string3.charAt(i);
            for (int j = 1; j < n2; ++j) {
                if (!stringArray[j].startsWith(string4)) break block1;
            }
            object = string4;
        }
        if (((String)object).length() > n3) {
            this.setEntry((String)object);
        }
    }

    @Override
    public void run() {
        int n;
        String string = this.entry.getText();
        int n2 = string.length();
        if (n2 == 0 || this.entry.getCaretPosition() != n2) {
            return;
        }
        this.listChoices(string, this.choiceList);
        if (this.choiceList.first < 0 || (n = this.choiceList.list.length) == 0) {
            return;
        }
        String string2 = null;
        for (int i = this.choiceList.first; i < n; ++i) {
            String string3 = AutoCompletion.toString(this.choiceList.list[i]);
            if (string3 == null || !string3.startsWith(string)) continue;
            string2 = string3;
            break;
        }
        if (string2 != null) {
            this.setEntry(string2);
            this.entry.moveCaretPosition(n2);
        }
    }

    public static enum AppendMode {
        UNSPECIFIED,
        AUTO,
        MANUAL,
        NONE;

    }

    public static enum AutoSuggest {
        UNSPECIFIED,
        YES,
        NO;

    }

    public static final class RichChoiceRenderer
    extends ChoiceRenderer {
        private TextIcon icon;
        private TextIcon selIcon;

        public RichChoiceRenderer() {
            this.setHorizontalTextPosition(2);
            this.setIconTextGap(AWTUtil.px(10));
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            Object object3;
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (this.icon == null) {
                object3 = this.getFont();
                object3 = AWTUtil.pxDeriveFont((Font)object3, 0, -2);
                object2 = jList.getBackground();
                object2 = AWTUtil.editHSB((Color)object2, 240, 0.3f, -0.5f, true);
                this.icon = new TextIcon(" ", (Font)object3, (Color)object2, null, jList);
                object2 = jList.getSelectionBackground();
                object2 = AWTUtil.editHSB((Color)object2, -1, 0.0f, -0.5f, true);
                this.selIcon = new TextIcon(" ", (Font)object3, (Color)object2, null, jList);
            }
            object3 = null;
            object2 = null;
            if (object instanceof RichChoice) {
                object2 = ((RichChoice)object).getChoiceDescription();
            }
            if (object2 != null) {
                object3 = bl ? this.selIcon : this.icon;
                if (((String)object2).length() > 40) {
                    object2 = ((String)object2).substring(0, 39) + "\u2026";
                }
                ((TextIcon)object3).setText((String)object2, jList);
            }
            this.setIcon((Icon)object3);
            return this;
        }
    }

    public static class ChoiceRenderer
    extends ZebraRenderer {
        private Font normalFont;
        private Font boldFont;

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            String string = null;
            if (object != null && (string = object.toString()).length() == 0) {
                string = Msg.msg("emptyString");
            }
            super.getListCellRendererComponent(jList, string, n, bl, bl2);
            boolean bl3 = !(object instanceof PossibleChoice) || ((PossibleChoice)object).isPossibleChoice();
            this.setEnabled(bl3);
            if (this.normalFont == null) {
                Font font = jList.getFont();
                this.normalFont = AWTUtil.pxDeriveFont(font, 0, 0);
                this.boldFont = AWTUtil.pxDeriveFont(font, 1, 0);
            }
            if (bl3) {
                this.setFont(this.normalFont);
            } else {
                this.setFont(this.boldFont);
            }
            return this;
        }
    }

    public static final class ProgressTextField
    extends JTextField
    implements ProgressMonitor {
        private final Color progressColor1 = new Color(0, 128, 0, 100);
        private final Color progressColor2 = new Color(0, 255, 0, 100);
        private int step = -1;
        private boolean wasEditable;
        private int stepCount;

        public ProgressTextField() {
            this(null, null, 0);
        }

        public ProgressTextField(int n) {
            this(null, null, n);
        }

        public ProgressTextField(String string) {
            this(null, string, 0);
        }

        public ProgressTextField(String string, int n) {
            this(null, string, n);
        }

        public ProgressTextField(Document document, String string, int n) {
            super(document, string, n);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.step >= 0) {
                int n;
                int n2;
                Graphics2D graphics2D = (Graphics2D)graphics;
                Paint paint = graphics2D.getPaint();
                int n3 = this.getWidth();
                int n4 = this.getHeight();
                if (this.stepCount > 0) {
                    n2 = 0;
                    n = n3 * (1 + this.step) / this.stepCount;
                } else {
                    n = n3 / 10;
                    n2 = n * (this.step % 10);
                }
                graphics2D.setPaint(new GradientPaint(n2, 0.0f, this.progressColor1, n2, n4 / 2, this.progressColor2, true));
                graphics2D.fillRect(n2, 0, n, n4);
                graphics2D.setPaint(paint);
            }
        }

        @Override
        public void start() {
            this.step = 0;
            this.wasEditable = this.isEditable();
            if (this.wasEditable) {
                this.setEditable(false);
            }
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        }

        @Override
        public boolean message(String string, Console.MessageType messageType) {
            return true;
        }

        @Override
        public boolean stepCount(int n) {
            this.stepCount = n < 0 ? -1 : 1 + n;
            return true;
        }

        @Override
        public boolean step(int n) {
            this.step = 1 + n;
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            return true;
        }

        @Override
        public void stop() {
            this.step = -1;
            if (this.wasEditable) {
                this.setEditable(true);
            }
            this.repaint();
        }
    }

    public static class MinimalChoices
    extends ChoicesBase {
        public MinimalChoices(Object[] objectArray) {
            super(objectArray);
        }

        @Override
        public void getChoices(String string, ChoiceList choiceList) {
            Object[] objectArray = this.getAll();
            AutoCompletion.minimalChoiceList(objectArray, string, choiceList);
        }

        @Override
        public boolean choiceListDependsOnPrefix() {
            return true;
        }
    }

    public static class SimpleChoices
    extends ChoicesBase {
        public SimpleChoices(Object[] objectArray) {
            super(objectArray);
        }

        @Override
        public void getChoices(String string, ChoiceList choiceList) {
            Object[] objectArray = this.getAll();
            AutoCompletion.simpleChoiceList(objectArray, string, choiceList);
        }

        @Override
        public boolean choiceListDependsOnPrefix() {
            return false;
        }
    }

    public static abstract class ChoicesBase
    implements Choices {
        protected Object[] list;

        protected ChoicesBase(Object[] objectArray) {
            this.list = objectArray;
        }

        public Object[] getAll() {
            return this.list;
        }
    }

    public static final class NoChoices
    implements Choices {
        @Override
        public void getChoices(String string, ChoiceList choiceList) {
            choiceList.list = ObjectUtil.NO_OBJECTS;
            choiceList.first = -1;
        }

        @Override
        public boolean choiceListDependsOnPrefix() {
            return false;
        }
    }

    public static interface SlowChoices
    extends Choices {
        public void getChoices(String var1, ChoiceList var2, ProgressMonitor var3);
    }

    public static interface Choices {
        public void getChoices(String var1, ChoiceList var2);

        public boolean choiceListDependsOnPrefix();
    }

    public static final class ChoiceList {
        public Object[] list;
        public int first;
    }

    public static interface RichChoice {
        public String getChoiceDescription();

        public URL getChoiceLocation();
    }

    public static interface PossibleChoice {
        public boolean isPossibleChoice();
    }
}

