/*
 * Decompiled with CFR 0.152.
 */
package org.tartarus.snowball;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.tartarus.snowball.SnowballStemmer;

public class TestApp {
    private static void usage() {
        System.err.println("Usage: TestApp <algorithm> [<input file>] [-o <output file>]");
    }

    public static void main(String[] stringArray) throws Throwable {
        int n;
        OutputStream outputStream;
        if (stringArray.length < 2) {
            TestApp.usage();
            return;
        }
        Class<?> clazz = Class.forName("org.tartarus.snowball.ext." + stringArray[0] + "Stemmer");
        SnowballStemmer snowballStemmer = (SnowballStemmer)clazz.newInstance();
        int n2 = 1;
        InputStream inputStream = stringArray.length > n2 && !stringArray[n2].equals("-o") ? new FileInputStream(stringArray[n2++]) : System.in;
        if (stringArray.length > n2) {
            if (stringArray.length != n2 + 2 || !stringArray[n2].equals("-o")) {
                TestApp.usage();
                return;
            }
            outputStream = new FileOutputStream(stringArray[n2 + 1]);
        } else {
            outputStream = System.out;
        }
        Reader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        reader = new BufferedReader(reader);
        Writer writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        writer = new BufferedWriter(writer);
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = reader.read()) != -1) {
            char c = (char)n;
            if (Character.isWhitespace(c)) {
                snowballStemmer.setCurrent(stringBuffer.toString());
                snowballStemmer.stem();
                writer.write(snowballStemmer.getCurrent());
                writer.write(10);
                stringBuffer.delete(0, stringBuffer.length());
                continue;
            }
            stringBuffer.append(c < '\u007f' ? Character.toLowerCase(c) : c);
        }
        writer.flush();
    }
}

